/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.logging.Logger;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Utils {
    private Utils() {
    }

    static CRSAuthorityFactory getDefaultFactory() throws FactoryException {
        return CRS.getAuthorityFactory((String)"EPSG");
    }

    static ImmutableEnvelope toGeographic(Class<?> caller, String method, Envelope areaOfInterest) {
        if (areaOfInterest != null) {
            try {
                DefaultGeographicBoundingBox bbox = new DefaultGeographicBoundingBox();
                bbox.setBounds(areaOfInterest);
                return new ImmutableEnvelope((GeographicBoundingBox)bbox);
            }
            catch (TransformException e) {
                Logging.recoverableException((Logger)LogHandler.LOGGER, caller, (String)method, (Throwable)e);
            }
        }
        return null;
    }

    static boolean intersects(ImmutableEnvelope areaOfInterest, ReferenceSystem crs) {
        GeographicBoundingBox bbox;
        boolean conservative = true;
        if (areaOfInterest != null && crs != null && (bbox = Extents.getGeographicBoundingBox((Extent)crs.getDomainOfValidity())) != null) {
            if (areaOfInterest.intersects((Envelope)new ImmutableEnvelope(bbox))) {
                return true;
            }
            conservative = false;
        }
        return conservative;
    }

    static boolean isIgnoreable(ReferenceSystem system) {
        return system instanceof CoordinateReferenceSystem && CommonCRS.Engineering.DISPLAY.datumUsedBy((CoordinateReferenceSystem)system);
    }
}

