/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;

final class DimensionReducer {
    private int[] dimensions;
    private CoordinateReferenceSystem reducedCRS;

    DimensionReducer(int ... dimensions) {
        this.dimensions = dimensions;
    }

    DimensionReducer(GridGeometry base, CoordinateReferenceSystem targetCRS) throws FactoryException {
        CoordinateReferenceSystem sourceCRS;
        if (base != null && base.envelope != null && (sourceCRS = base.envelope.getCoordinateReferenceSystem()) != null) {
            CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
            CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
            if (sourceCS.getDimension() < targetCS.getDimension()) {
                this.dimensions = AxisDirections.indicesOfLenientMapping((CoordinateSystem)targetCS, (CoordinateSystem)sourceCS);
                if (this.dimensions != null) {
                    Arrays.sort(this.dimensions);
                    this.reducedCRS = CRS.selectDimensions((CoordinateReferenceSystem)targetCRS, (int[])this.dimensions);
                }
            }
        }
    }

    private double[] apply(double[] target) {
        if (target == null || this.dimensions == null) {
            return target;
        }
        double[] resolution = new double[this.dimensions.length];
        for (int i = 0; i < resolution.length; ++i) {
            resolution[i] = target[this.dimensions[i]];
        }
        return resolution;
    }

    final DirectPosition apply(DirectPosition target) {
        if (target == null || this.dimensions == null) {
            return target;
        }
        GeneralDirectPosition position = new GeneralDirectPosition(this.reducedCRS);
        for (int i = 0; i < this.dimensions.length; ++i) {
            position.coordinates[i] = target.getOrdinate(this.dimensions[i]);
        }
        return position;
    }

    final Envelope apply(Envelope target) {
        if (target == null || this.dimensions == null) {
            return target;
        }
        DirectPosition lowerCorner = target.getLowerCorner();
        DirectPosition upperCorner = target.getUpperCorner();
        GeneralEnvelope envelope = new GeneralEnvelope(this.reducedCRS);
        for (int i = 0; i < this.dimensions.length; ++i) {
            int s = this.dimensions[i];
            envelope.setRange(i, lowerCorner.getOrdinate(s), upperCorner.getOrdinate(s));
        }
        return envelope;
    }

    final GridGeometry apply(GridGeometry target) throws FactoryException {
        GridExtent extent;
        MathTransform cornerToCRS;
        if (target == null || this.dimensions == null) {
            return target;
        }
        int[] gridIndices = null;
        MathTransform gridToCRS = target.gridToCRS;
        if (gridToCRS != null) {
            TransformSeparator ts = new TransformSeparator(gridToCRS);
            ts.addTargetDimensions(this.dimensions);
            gridToCRS = ts.separate();
            gridIndices = ts.getSourceDimensions();
        }
        if ((cornerToCRS = target.cornerToCRS) != null) {
            TransformSeparator ts = new TransformSeparator(cornerToCRS);
            ts.addTargetDimensions(this.dimensions);
            if (gridIndices != null) {
                ts.addSourceDimensions(gridIndices);
                cornerToCRS = ts.separate();
            } else {
                cornerToCRS = ts.separate();
                gridIndices = ts.getSourceDimensions();
            }
        }
        if ((extent = target.extent) != null && gridIndices != null) {
            extent = extent.selectDimensions(gridIndices);
        }
        this.reducedCRS = CRS.selectDimensions((CoordinateReferenceSystem)target.getCoordinateReferenceSystem(), (int[])this.dimensions);
        Envelope envelope = this.apply((Envelope)target.envelope);
        double[] resolution = this.apply(target.resolution);
        long nonLinears = 0L;
        for (int i = 0; i < this.dimensions.length; ++i) {
            if ((target.nonLinears & 1L << this.dimensions[i]) == 0L) continue;
            nonLinears |= 1L << i;
        }
        return new GridGeometry(extent, gridToCRS, cornerToCRS, ImmutableEnvelope.castOrCopy((Envelope)envelope), resolution, nonLinears);
    }
}

