/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.math;

import java.io.ObjectStreamException;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.UnaryFunction;
import org.apache.sis.filter.math.Function;
import org.opengis.util.ScopedName;

final class UnaryOperator<R>
extends UnaryFunction<R, Number>
implements FeatureExpression<R, Double>,
Optimization.OnExpression<R, Double> {
    private static final long serialVersionUID = -6215509464490587978L;
    private final Function function;
    private final transient DoubleUnaryOperator math;

    UnaryOperator(Function function, Expression<R, ? extends Number> expression) {
        super(expression);
        this.function = function;
        this.math = Objects.requireNonNull(function.unary);
    }

    private Object readResolve() throws ObjectStreamException {
        return new UnaryOperator<R>(this.function, this.expression);
    }

    @Override
    public ScopedName getFunctionName() {
        return this.function.getFunctionName();
    }

    @Override
    public final Class<Double> getResultClass() {
        return Double.class;
    }

    @Override
    public final FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        return addTo.addSourceProperty(this.function.getResultType(), false);
    }

    @Override
    public final Double apply(R feature) {
        Number value = (Number)this.expression.apply(feature);
        if (value != null) {
            return this.math.applyAsDouble(value.doubleValue());
        }
        return null;
    }
}

