/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.style.se1.Graphic;
import org.apache.sis.style.se1.GraphicalElement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Symbolizer;

@XmlType(name="PointSymbolizerType")
@XmlRootElement(name="PointSymbolizer")
public class PointSymbolizer<R>
extends Symbolizer<R>
implements GraphicalElement<R> {
    @XmlElement(name="Graphic")
    protected Graphic<R> graphic;
    private boolean isGraphicSet;

    private void beforeMarshal(Marshaller caller) {
        if (this.graphic == null && !this.isGraphicSet) {
            this.graphic = this.factory.createGraphic();
        }
    }

    private PointSymbolizer() {
        this.isGraphicSet = true;
    }

    public PointSymbolizer(StyleFactory<R> factory) {
        super(factory);
    }

    public PointSymbolizer(PointSymbolizer<R> source) {
        super(source);
        this.graphic = source.graphic;
    }

    @Override
    public Graphic<R> getGraphic() {
        if (this.graphic == null) {
            this.graphic = this.factory.createGraphic();
        }
        return this.graphic;
    }

    @Override
    public void setGraphic(Graphic<R> value) {
        this.isGraphicSet = true;
        this.graphic = value;
    }

    @Override
    public boolean isVisible() {
        return this.graphic != null || !this.isGraphicSet;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.graphic, this.isGraphicSet};
    }

    @Override
    public PointSymbolizer<R> clone() {
        PointSymbolizer clone = (PointSymbolizer)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.graphic != null) {
            this.graphic = this.graphic.clone();
        }
    }
}

