/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.DistributionComponent;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(property={"name=default"})
public class DefaultDistributionComponentProvider
implements DistributionComponentProvider {
    private static final String NAME = "name";
    private final Map<String, DistributionComponent<DistributionAgent>> distributionAgentMap = new ConcurrentHashMap<String, DistributionComponent<DistributionAgent>>();
    private final Map<String, DistributionComponent<DistributionQueueProvider>> distributionQueueProviderMap = new ConcurrentHashMap<String, DistributionComponent<DistributionQueueProvider>>();
    private final Map<String, DistributionComponent<DistributionQueueDispatchingStrategy>> distributionQueueDistributionStrategyMap = new ConcurrentHashMap<String, DistributionComponent<DistributionQueueDispatchingStrategy>>();
    private final Map<String, DistributionComponent<DistributionTransportSecretProvider>> distributionTransportSecretProviderMap = new ConcurrentHashMap<String, DistributionComponent<DistributionTransportSecretProvider>>();
    private final Map<String, DistributionComponent<DistributionPackageImporter>> distributionPackageImporterMap = new ConcurrentHashMap<String, DistributionComponent<DistributionPackageImporter>>();
    private final Map<String, DistributionComponent<DistributionPackageExporter>> distributionPackageExporterMap = new ConcurrentHashMap<String, DistributionComponent<DistributionPackageExporter>>();
    private final Map<String, DistributionComponent<DistributionPackageBuilder>> distributionPackageBuilderMap = new ConcurrentHashMap<String, DistributionComponent<DistributionPackageBuilder>>();
    private final Map<String, DistributionComponent<DistributionTrigger>> distributionTriggerMap = new ConcurrentHashMap<String, DistributionComponent<DistributionTrigger>>();
    private final Map<String, DistributionComponent<DistributionRequestAuthorizationStrategy>> distributionRequestAuthorizationStrategy = new ConcurrentHashMap<String, DistributionComponent<DistributionRequestAuthorizationStrategy>>();

    @Override
    public DistributionComponent<?> getComponent(DistributionComponentKind kind, String componentName) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(kind.asClass());
        return componentMap.get(componentName);
    }

    @Override
    public List<DistributionComponent<?>> getComponents(DistributionComponentKind kind) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(kind.asClass());
        ArrayList componentList = new ArrayList();
        componentList.addAll(componentMap.values());
        return componentList;
    }

    @Override
    public <ComponentType> ComponentType getService(Class<ComponentType> type, String componentName) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(type);
        DistributionComponent<?> component = componentMap.get(componentName);
        if (component == null) {
            return null;
        }
        return type.cast(component.getService());
    }

    private Map<String, DistributionComponent<?>> getComponentMap(Class<?> type) {
        if (type.isAssignableFrom(DistributionAgent.class)) {
            return this.distributionAgentMap;
        }
        if (type.isAssignableFrom(DistributionPackageExporter.class)) {
            return this.distributionPackageExporterMap;
        }
        if (type.isAssignableFrom(DistributionPackageImporter.class)) {
            return this.distributionPackageImporterMap;
        }
        if (type.isAssignableFrom(DistributionQueueProvider.class)) {
            return this.distributionQueueProviderMap;
        }
        if (type.isAssignableFrom(DistributionQueueDispatchingStrategy.class)) {
            return this.distributionQueueDistributionStrategyMap;
        }
        if (type.isAssignableFrom(DistributionTransportSecretProvider.class)) {
            return this.distributionTransportSecretProviderMap;
        }
        if (type.isAssignableFrom(DistributionPackageBuilder.class)) {
            return this.distributionPackageBuilderMap;
        }
        if (type.isAssignableFrom(DistributionTrigger.class)) {
            return this.distributionTriggerMap;
        }
        if (type.isAssignableFrom(DistributionRequestAuthorizationStrategy.class)) {
            return this.distributionRequestAuthorizationStrategy;
        }
        throw new IllegalArgumentException(String.format("Components of type: %s\u00a0are not supported", type));
    }

    @Reference(name="distributionQueueProvider", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionQueueProvider(DistributionQueueProvider distributionQueueProvider, Map<String, Object> config) {
        this.put(DistributionQueueProvider.class, distributionQueueProvider, config);
    }

    public void unbindDistributionQueueProvider(DistributionQueueProvider distributionQueueProvider, Map<String, Object> config) {
        this.remove(DistributionQueueProvider.class, distributionQueueProvider, config);
    }

    @Reference(name="distributionQueueDistributionStrategy", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionQueueDistributionStrategy(DistributionQueueDispatchingStrategy distributionQueueDispatchingStrategy, Map<String, Object> config) {
        this.put(DistributionQueueDispatchingStrategy.class, distributionQueueDispatchingStrategy, config);
    }

    public void unbindDistributionQueueDistributionStrategy(DistributionQueueDispatchingStrategy distributionQueueDispatchingStrategy, Map<String, Object> config) {
        this.remove(DistributionQueueDispatchingStrategy.class, distributionQueueDispatchingStrategy, config);
    }

    @Reference(name="distributionTransportSecretProvider", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider, Map<String, Object> config) {
        this.put(DistributionTransportSecretProvider.class, distributionTransportSecretProvider, config);
    }

    public void unbindDistributionTransportSecretProvider(DistributionTransportSecretProvider distributionTransportSecretProvider, Map<String, Object> config) {
        this.remove(DistributionTransportSecretProvider.class, distributionTransportSecretProvider, config);
    }

    @Reference(name="distributionPackageImporter", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionPackageImporter(DistributionPackageImporter distributionPackageImporter, Map<String, Object> config) {
        this.put(DistributionPackageImporter.class, distributionPackageImporter, config);
    }

    public void unbindDistributionPackageImporter(DistributionPackageImporter distributionPackageImporter, Map<String, Object> config) {
        this.remove(DistributionPackageImporter.class, distributionPackageImporter, config);
    }

    @Reference(name="distributionPackageExporter", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionPackageExporter(DistributionPackageExporter distributionPackageExporter, Map<String, Object> config) {
        this.put(DistributionPackageExporter.class, distributionPackageExporter, config);
    }

    public void unbindDistributionPackageExporter(DistributionPackageExporter distributionPackageExporter, Map<String, Object> config) {
        this.remove(DistributionPackageExporter.class, distributionPackageExporter, config);
    }

    @Reference(name="distributionAgent", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionAgent(DistributionAgent distributionAgent, Map<String, Object> config) {
        this.put(DistributionAgent.class, distributionAgent, config);
    }

    public void unbindDistributionAgent(DistributionAgent distributionAgent, Map<String, Object> config) {
        this.remove(DistributionAgent.class, distributionAgent, config);
    }

    @Reference(name="distributionPackageBuilder", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionPackageBuilder(DistributionPackageBuilder distributionPackageBuilder, Map<String, Object> config) {
        this.put(DistributionPackageBuilder.class, distributionPackageBuilder, config);
    }

    public void unbindDistributionPackageBuilder(DistributionPackageBuilder distributionPackageBuilder, Map<String, Object> config) {
        this.remove(DistributionPackageBuilder.class, distributionPackageBuilder, config);
    }

    @Reference(name="distributionTrigger", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        this.put(DistributionTrigger.class, distributionTrigger, config);
    }

    public void unbindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        this.remove(DistributionTrigger.class, distributionTrigger, config);
    }

    @Reference(name="distributionRequestAuthorizationStrategy", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindDistributionRequestAuthorizationStrategy(DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy, Map<String, Object> config) {
        this.put(DistributionRequestAuthorizationStrategy.class, distributionRequestAuthorizationStrategy, config);
    }

    public void unbindDistributionRequestAuthorizationStrategy(DistributionRequestAuthorizationStrategy distributionRequestAuthorizationStrategy, Map<String, Object> config) {
        this.remove(DistributionRequestAuthorizationStrategy.class, distributionRequestAuthorizationStrategy, config);
    }

    private <ComponentType> void put(Class<ComponentType> typeClass, ComponentType service, Map<String, Object> config) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(typeClass);
        String name = PropertiesUtil.toString((Object)config.get(NAME), null);
        DistributionComponentKind kind = DistributionComponentKind.fromClass(typeClass);
        if (name != null && kind != null) {
            componentMap.put(name, new DistributionComponent<ComponentType>(kind, name, service, config));
        }
    }

    private <ComponentType> void remove(Class<ComponentType> typeClass, ComponentType service, Map<String, Object> config) {
        Map<String, DistributionComponent<?>> componentMap = this.getComponentMap(typeClass);
        String name = PropertiesUtil.toString((Object)config.get(NAME), null);
        if (name != null) {
            componentMap.remove(name);
        }
    }
}

