/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    private T next;

    protected AbstractIterator() {
    }

    protected abstract T computeNext();

    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case READY: {
                return true;
            }
            case DONE: {
                return false;
            }
            case NOT_READY: {
                return this.tryToComputeNext();
            }
        }
        throw new IllegalStateException("Iterator in failed state");
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = this.next;
        this.next = null;
        return result;
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state == State.DONE) {
            return false;
        }
        this.state = State.READY;
        return true;
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

