/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import javax.script.Bindings;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.models.SlingBindingsModel;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SlingBindingsTest {
    @Rule
    public SlingContext context = new SlingContext(ResourceResolverType.JCR_MOCK);
    private Resource currentResource;

    @Before
    public void setUp() throws Exception {
        this.context.registerService(BindingsValuesProvider.class, new BindingsValuesProvider(){

            public void addBindings(Bindings bindings) {
                bindings.put("custom-param-1", (Object)"value-1");
            }
        });
        this.context.registerService(BindingsValuesProvider.class, new BindingsValuesProvider(){

            public void addBindings(Bindings bindings) {
                bindings.put("custom-param-2", (Object)"value-2");
            }
        }, new Object[]{"MockSlingBindings-ignore", true});
        this.context.addModelsForClasses(new Class[]{SlingBindingsModel.class});
        this.currentResource = this.context.create().resource("/content/testPage/testResource");
        this.context.currentResource(this.currentResource);
        this.context.registerService(BindingsValuesProvider.class, new BindingsValuesProvider(){

            public void addBindings(Bindings bindings) {
                bindings.put("custom-param-3", (Object)"value-3");
            }
        });
        Thread.sleep(25L);
    }

    @Test
    public void testModelBindings() {
        SlingBindingsModel model = (SlingBindingsModel)this.context.jakartaRequest().adaptTo(SlingBindingsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getResolver());
        Assert.assertNotNull((Object)model.getResource());
        Assert.assertEquals((Object)this.currentResource.getPath(), (Object)model.getResource().getPath());
        Assert.assertNotNull((Object)model.getJakartaRequest());
        Assert.assertNotNull((Object)model.getJakartaResponse());
        Assert.assertNotNull((Object)model.getRequest());
        Assert.assertNotNull((Object)model.getResponse());
        Assert.assertNotNull((Object)model.getCurrentNode());
        Assert.assertNotNull((Object)model.getCurrentSession());
        Assert.assertEquals((Object)"value-1", (Object)model.getCustomParam1());
        Assert.assertNull((Object)model.getCustomParam2());
        Assert.assertEquals((Object)"value-3", (Object)model.getCustomParam3());
    }

    @Test
    public void testCustomBindingsValuesProvider() {
        SlingBindings bindings = (SlingBindings)this.context.jakartaRequest().getAttribute(SlingBindings.class.getName());
        Assert.assertNotNull((Object)bindings);
        Assert.assertEquals((Object)this.currentResource.getPath(), (Object)bindings.getResource().getPath());
        Assert.assertEquals((Object)"value-1", (Object)bindings.get((Object)"custom-param-1"));
        Assert.assertNull((Object)bindings.get((Object)"custom-param-2"));
        Assert.assertEquals((Object)"value-3", (Object)bindings.get((Object)"custom-param-3"));
    }
}

