// RUN: rm -rf %t
// RUN: split-file %s %t
// RUN: sed -e "s@INPUT_DIR@%{/t:regex_replacement}@g" \
// RUN: %t/reference.output.json.in >> %t/reference.output.json
// RUN: %clang -extract-api --pretty-sgf -x objective-c-header -target arm64-apple-macosx \
// RUN: %t/input.h -o %t/output.json | FileCheck -allow-empty %s

// Generator version is not consistent across test runs, normalize it.
// RUN: sed -e "s@\"generator\": \".*\"@\"generator\": \"?\"@g" \
// RUN: %t/output.json >> %t/output-normalized.json
// RUN: diff %t/reference.output.json %t/output-normalized.json

// CHECK-NOT: error:
// CHECK-NOT: warning:

//--- input.h
@protocol Protocol
@end

@protocol AnotherProtocol <Protocol>
@end

//--- reference.output.json.in
{
  "metadata": {
    "formatVersion": {
      "major": 0,
      "minor": 5,
      "patch": 3
    },
    "generator": "?"
  },
  "module": {
    "name": "",
    "platform": {
      "architecture": "arm64",
      "operatingSystem": {
        "minimumVersion": {
          "major": 11,
          "minor": 0,
          "patch": 0
        },
        "name": "macosx"
      },
      "vendor": "apple"
    }
  },
  "relationships": [
    {
      "kind": "conformsTo",
      "source": "c:objc(pl)AnotherProtocol",
      "target": "c:objc(pl)Protocol",
      "targetFallback": "Protocol"
    }
  ],
  "symbols": [
    {
      "accessLevel": "public",
      "declarationFragments": [
        {
          "kind": "keyword",
          "spelling": "@protocol"
        },
        {
          "kind": "text",
          "spelling": " "
        },
        {
          "kind": "identifier",
          "spelling": "Protocol"
        }
      ],
      "identifier": {
        "interfaceLanguage": "objective-c",
        "precise": "c:objc(pl)Protocol"
      },
      "kind": {
        "displayName": "Protocol",
        "identifier": "objective-c.protocol"
      },
      "location": {
        "position": {
          "character": 10,
          "line": 0
        },
        "uri": "file://INPUT_DIR/input.h"
      },
      "names": {
        "navigator": [
          {
            "kind": "identifier",
            "spelling": "Protocol"
          }
        ],
        "subHeading": [
          {
            "kind": "identifier",
            "spelling": "Protocol"
          }
        ],
        "title": "Protocol"
      },
      "pathComponents": [
        "Protocol"
      ]
    },
    {
      "accessLevel": "public",
      "declarationFragments": [
        {
          "kind": "keyword",
          "spelling": "@protocol"
        },
        {
          "kind": "text",
          "spelling": " "
        },
        {
          "kind": "identifier",
          "spelling": "AnotherProtocol"
        },
        {
          "kind": "text",
          "spelling": " <"
        },
        {
          "kind": "typeIdentifier",
          "preciseIdentifier": "c:objc(pl)Protocol",
          "spelling": "Protocol"
        },
        {
          "kind": "text",
          "spelling": ">"
        }
      ],
      "identifier": {
        "interfaceLanguage": "objective-c",
        "precise": "c:objc(pl)AnotherProtocol"
      },
      "kind": {
        "displayName": "Protocol",
        "identifier": "objective-c.protocol"
      },
      "location": {
        "position": {
          "character": 10,
          "line": 3
        },
        "uri": "file://INPUT_DIR/input.h"
      },
      "names": {
        "navigator": [
          {
            "kind": "identifier",
            "spelling": "AnotherProtocol"
          }
        ],
        "subHeading": [
          {
            "kind": "identifier",
            "spelling": "AnotherProtocol"
          }
        ],
        "title": "AnotherProtocol"
      },
      "pathComponents": [
        "AnotherProtocol"
      ]
    }
  ]
}
