; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=i686-apple-darwin -mattr=+avx2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=+avx2 | FileCheck %s --check-prefix=X64
; RUN: llc < %s -disable-peephole -mtriple=i686-apple-darwin -mattr=+avx512vl,avx512bw | FileCheck %s --check-prefix=X86
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=+avx512vl,avx512bw | FileCheck %s --check-prefix=X64

define <16 x i16> @test_llvm_x86_avx2_pmovsxbw(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovsxbw:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovsxbw (%eax), %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovsxbw:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovsxbw (%rdi), %ymm0
; X64-NEXT:    retq
  %1 = load <16 x i8>, ptr %a, align 1
  %2 = sext <16 x i8> %1 to <16 x i16>
  ret <16 x i16> %2
}

define <8 x i32> @test_llvm_x86_avx2_pmovsxbd(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovsxbd:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovsxbd (%eax), %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovsxbd:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovsxbd (%rdi), %ymm0
; X64-NEXT:    retq
  %1 = load <16 x i8>, ptr %a, align 1
  %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = sext <8 x i8> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <4 x i64> @test_llvm_x86_avx2_pmovsxbq(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovsxbq:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovsxbq (%eax), %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovsxbq:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovsxbq (%rdi), %ymm0
; X64-NEXT:    retq
  %1 = load <16 x i8>, ptr %a, align 1
  %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = sext <4 x i8> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <8 x i32> @test_llvm_x86_avx2_pmovsxwd(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovsxwd:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovsxwd (%eax), %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovsxwd:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovsxwd (%rdi), %ymm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, ptr %a, align 1
  %2 = sext <8 x i16> %1 to <8 x i32>
  ret <8 x i32> %2
}

define <4 x i64> @test_llvm_x86_avx2_pmovsxwq(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovsxwq:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovsxwq (%eax), %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovsxwq:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovsxwq (%rdi), %ymm0
; X64-NEXT:    retq
  %1 = load <8 x i16>, ptr %a, align 1
  %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = sext <4 x i16> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_llvm_x86_avx2_pmovsxdq(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovsxdq:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovsxdq (%eax), %ymm0
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovsxdq:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovsxdq (%rdi), %ymm0
; X64-NEXT:    retq
  %1 = load <4 x i32>, ptr %a, align 1
  %2 = sext <4 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <16 x i16> @test_llvm_x86_avx2_pmovzxbw(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovzxbw:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovzxbw {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero,mem[8],zero,mem[9],zero,mem[10],zero,mem[11],zero,mem[12],zero,mem[13],zero,mem[14],zero,mem[15],zero
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovzxbw:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovzxbw {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero,mem[8],zero,mem[9],zero,mem[10],zero,mem[11],zero,mem[12],zero,mem[13],zero,mem[14],zero,mem[15],zero
; X64-NEXT:    retq
  %1 = load <16 x i8>, ptr %a, align 1
  %2 = zext <16 x i8> %1 to <16 x i16>
  ret <16 x i16> %2
}

define <8 x i32> @test_llvm_x86_avx2_pmovzxbd(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovzxbd:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovzxbd {{.*#+}} ymm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovzxbd:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovzxbd {{.*#+}} ymm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero,mem[4],zero,zero,zero,mem[5],zero,zero,zero,mem[6],zero,zero,zero,mem[7],zero,zero,zero
; X64-NEXT:    retq
  %1 = load <16 x i8>, ptr %a, align 1
  %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = zext <8 x i8> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <4 x i64> @test_llvm_x86_avx2_pmovzxbq(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovzxbq:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovzxbq {{.*#+}} ymm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero,mem[2],zero,zero,zero,zero,zero,zero,zero,mem[3],zero,zero,zero,zero,zero,zero,zero
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovzxbq:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovzxbq {{.*#+}} ymm0 = mem[0],zero,zero,zero,zero,zero,zero,zero,mem[1],zero,zero,zero,zero,zero,zero,zero,mem[2],zero,zero,zero,zero,zero,zero,zero,mem[3],zero,zero,zero,zero,zero,zero,zero
; X64-NEXT:    retq
  %1 = load <16 x i8>, ptr %a, align 1
  %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = zext <4 x i8> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <8 x i32> @test_llvm_x86_avx2_pmovzxwd(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovzxwd:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovzxwd {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovzxwd:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovzxwd {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero,mem[4],zero,mem[5],zero,mem[6],zero,mem[7],zero
; X64-NEXT:    retq
  %1 = load <8 x i16>, ptr %a, align 1
  %2 = zext <8 x i16> %1 to <8 x i32>
  ret <8 x i32> %2
}

define <4 x i64> @test_llvm_x86_avx2_pmovzxwq(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovzxwq:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovzxwq {{.*#+}} ymm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovzxwq:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovzxwq {{.*#+}} ymm0 = mem[0],zero,zero,zero,mem[1],zero,zero,zero,mem[2],zero,zero,zero,mem[3],zero,zero,zero
; X64-NEXT:    retq
  %1 = load <8 x i16>, ptr %a, align 1
  %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = zext <4 x i16> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_llvm_x86_avx2_pmovzxdq(ptr %a) {
; X86-LABEL: test_llvm_x86_avx2_pmovzxdq:
; X86:       ## %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vpmovzxdq {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; X86-NEXT:    retl
;
; X64-LABEL: test_llvm_x86_avx2_pmovzxdq:
; X64:       ## %bb.0:
; X64-NEXT:    vpmovzxdq {{.*#+}} ymm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; X64-NEXT:    retq
  %1 = load <4 x i32>, ptr %a, align 1
  %2 = zext <4 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}
