/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox;

import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Log {
    private static ServiceTracker logTracker;
    private static boolean useLog;

    static {
        useLog = false;
    }

    public static void dispose() {
        if (logTracker != null) {
            logTracker.close();
        }
        logTracker = null;
    }

    public static void init(BundleContext bc) {
        logTracker = new ServiceTracker(bc, LogService.class.getName(), null);
        logTracker.open();
    }

    static void debug(Object obj, String method, String message) {
        Log.log(4, obj, method, message, null);
    }

    static void warn(Object obj, String method, String message) {
        Log.log(2, obj, method, message, null);
    }

    static void info(Object obj, String method, String message) {
        Log.log(3, obj, method, message, null);
    }

    private static void log(int level, Object obj, String method, String message, Throwable e) {
        LogService logService = null;
        Object msg = "";
        if (method == null) {
            if (obj != null) {
                msg = "(" + obj.getClass().getName() + ")";
            }
        } else {
            msg = obj == null ? "[" + method + "]" + message : "[" + method + "](" + obj.getClass().getName() + ")";
        }
        msg = (String)msg + message;
        if (logTracker != null) {
            logService = (LogService)logTracker.getService();
        }
        if (logService != null) {
            logService.log(level, (String)msg, e);
        } else {
            String levelSt = null;
            if (level == 4) {
                levelSt = "DEBUG";
            } else if (level == 3) {
                levelSt = "INFO";
            } else if (level == 2) {
                levelSt = "WARNING";
            } else if (level == 1) {
                levelSt = "ERROR";
                useLog = true;
            }
            if (useLog) {
                System.err.println("[" + levelSt + "]" + (String)msg);
                if (e != null) {
                    e.printStackTrace();
                }
            }
        }
    }

    static void warn(Object obj, String method, Throwable e) {
        Log.log(2, obj, method, null, e);
    }

    static void debug(String message) {
        Log.log(4, null, null, message, null);
    }

    static void warn(String message) {
        Log.log(2, null, null, message, null);
    }

    static void info(String message) {
        Log.log(3, null, null, message, null);
    }

    static void error(String message) {
        Log.log(1, null, null, message, null);
    }

    static void error(String message, Throwable e) {
        Log.log(1, null, null, message, e);
    }

    private Log() {
    }
}

