/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.boundedresponse;

import java.util.List;
import org.eclipse.escet.common.java.Assert;

public class Bound {
    private final boolean hasInitialState;
    private final boolean bounded;
    private final Integer bound;
    private final List<String> cycleEdges;
    private final List<String> cycleStates;

    public Bound(boolean hasInitialState, boolean bounded, Integer bound, List<String> cycleEdges, List<String> cycleStates) {
        this.hasInitialState = hasInitialState;
        this.bounded = bounded;
        this.bound = bound;
        this.cycleEdges = cycleEdges;
        this.cycleStates = cycleStates;
        Assert.areEqual((Object)bounded, (Object)(bound != null ? 1 : 0));
        Assert.areEqual((Object)bounded, (Object)(cycleEdges == null ? 1 : 0));
        Assert.check((cycleEdges == null || !cycleEdges.isEmpty() ? 1 : 0) != 0);
        Assert.areEqual((Object)bounded, (Object)(cycleStates == null ? 1 : 0));
    }

    public boolean hasInitialState() {
        return this.hasInitialState;
    }

    public boolean isBounded() {
        return this.bounded;
    }

    public int getBound() {
        if (!this.bounded) {
            throw new IllegalArgumentException("Not bounded");
        }
        return this.bound;
    }

    public List<String> getCycleEdges() {
        if (this.bounded) {
            throw new IllegalArgumentException("Bounded");
        }
        return this.cycleEdges;
    }

    public List<String> getCycleStates() {
        if (this.bounded) {
            throw new IllegalArgumentException("Bounded");
        }
        return this.cycleStates;
    }
}

