/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.orderers;

import java.util.List;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.bdd.varorder.helper.RepresentationKind;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrder;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ReverseVarOrderer
extends VarOrderer {
    private final RelationsKind relationsKind;
    private final VarOrdererEffect effect;

    public ReverseVarOrderer(RelationsKind relationsKind, VarOrdererEffect effect) {
        this.relationsKind = relationsKind;
        this.effect = effect;
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        List<CifBddVariable> orderedVars = inputData.varOrder.getOrderedVars();
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Reversing the variable order:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Relations: %s", this.enumValueToParserArg(this.relationsKind));
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
            inputData.helper.dbgRepresentation(dbgLevel + 1, RepresentationKind.HYPER_EDGES, this.relationsKind);
            inputData.helper.dbg();
            inputData.helper.dbgMetricsForVarOrder(dbgLevel + 1, orderedVars, "before", this.relationsKind);
        }
        List varOrder = inputData.varOrder.getVarOrder();
        varOrder = varOrder.stream().map(grp -> Lists.reverse((List)grp)).toList();
        varOrder = Lists.reverse(varOrder);
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForVarOrder(dbgLevel + 1, orderedVars, "reversed", this.relationsKind);
        }
        return new VarOrdererData(inputData, new VarOrder(varOrder), this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"reverse(relations=%s, effect=%s)", (Object[])new Object[]{this.enumValueToParserArg(this.relationsKind), this.enumValueToParserArg(this.effect)});
    }
}

