/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.dsm.MatrixHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class MarkovClustering {
    private MarkovClustering() {
    }

    public static List<BitSet> markovClustering(RealMatrix m, int stepCount, double inflation, double[] pruningLimit, double epsilon, DebugNormalOutput dbg) {
        Assert.check((stepCount > 0 ? 1 : 0) != 0);
        Assert.check((boolean)m.isSquare());
        int size = m.getRowDimension();
        dbg.line();
        dbg.line("Input to Markov:");
        dbg.line(m.toString());
        int k = 0;
        RealMatrix prev = null;
        while (prev == null || !MarkovClustering.convergenceReached(m, prev, epsilon)) {
            Assert.check((++k < 500000 ? 1 : 0) != 0, (Object)"Max number of iterations exceeded.");
            prev = m.copy();
            m = m.power(stepCount);
            m = MatrixHelper.scalarPower(m, inflation);
            MatrixHelper.normalizeColumns(m, false);
            MatrixHelper.prune(m, pruningLimit);
        }
        dbg.line("Output from Markov:");
        dbg.line(m.toString());
        dbg.line();
        Map clusterMap = Maps.map();
        List clusters = Lists.list();
        int j = 0;
        while (j < size) {
            double[] col = m.getColumn(j);
            int largestRow = 0;
            double largest = 0.0;
            int i = 0;
            while (i < size) {
                if (i == 0 || largest <= col[i]) {
                    largest = col[i];
                    largestRow = i;
                }
                ++i;
            }
            BitSet row = (BitSet)clusterMap.get(largestRow);
            if (row == null) {
                row = BitSets.bitset((int)size);
                row.set(j);
                clusterMap.put(largestRow, row);
                clusters.add(row);
            } else {
                row.set(j);
            }
            ++j;
        }
        return clusters;
    }

    private static boolean convergenceReached(RealMatrix matP, RealMatrix matQ, double epsilon) {
        Assert.areEqual((Object)matP.getColumnDimension(), (Object)matQ.getColumnDimension());
        Assert.areEqual((Object)matP.getRowDimension(), (Object)matQ.getRowDimension());
        int i = 0;
        while (i < matP.getRowDimension()) {
            int j = 0;
            while (j < matP.getColumnDimension()) {
                double absDiff = Math.abs(matP.getEntry(i, j) - matQ.getEntry(i, j));
                if (absDiff > epsilon) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

