/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.features.core.model.ModelSubmissionHandler;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.features.core.model.SourceModelStorage;
import org.eclipse.glsp.server.features.progress.ProgressMonitor;
import org.eclipse.glsp.server.features.progress.ProgressService;
import org.eclipse.glsp.server.features.sourcemodelwatcher.SourceModelWatcher;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;
import org.eclipse.glsp.server.utils.StatusActionUtil;

public class RequestModelActionHandler
extends AbstractActionHandler<RequestModelAction> {
    @Inject
    protected SourceModelStorage sourceModelStorage;
    @Inject
    protected ActionDispatcher actionDispatcher;
    @Inject
    protected Optional<SourceModelWatcher> sourceModelWatcher;
    @Inject
    protected ModelSubmissionHandler modelSubmissionHandler;
    @Inject
    protected ProgressService progressService;
    @Inject
    protected GModelState modelState;

    @Override
    public List<Action> executeAction(RequestModelAction action) {
        this.modelState.setClientOptions(action.getOptions());
        boolean isReconnecting = ClientOptionsUtil.isReconnecting(action.getOptions());
        ProgressMonitor monitor = this.notifyStartLoading();
        if (isReconnecting) {
            this.handleReconnect(action);
        } else {
            this.sourceModelStorage.loadSourceModel(action);
        }
        this.notifyFinishedLoading(monitor);
        if (!isReconnecting) {
            this.sourceModelWatcher.ifPresent(watcher -> watcher.startWatching());
        }
        return this.modelSubmissionHandler.submitInitialModel(action);
    }

    protected void handleReconnect(RequestModelAction action) {
        GModelRoot oldModel = (GModelRoot)this.modelState.getRoot();
        if (oldModel != null) {
            ((GModelRoot)this.modelState.getRoot()).setRevision(oldModel.getRevision() - 1);
        } else {
            this.sourceModelStorage.loadSourceModel(action);
        }
    }

    protected ProgressMonitor notifyStartLoading() {
        String message = "Model loading in progress";
        this.actionDispatcher.dispatch(StatusActionUtil.info(message));
        return this.progressService.start(message);
    }

    protected void notifyFinishedLoading(ProgressMonitor monitor) {
        this.actionDispatcher.dispatch(StatusActionUtil.clear());
        monitor.end();
    }
}

