/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.io.File;
import java.util.Properties;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.quarkus.QuarkusUtils;
import org.eclipse.jkube.quarkus.generator.QuarkusGenerator;

public class QuarkusAssemblies {
    public static final QuarkusAssembly NATIVE = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        Properties quarkusConfiguration = QuarkusUtils.getQuarkusConfiguration(project);
        AssemblyFileSet artifactFileSet = QuarkusAssemblies.createFileSet(project).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).include(QuarkusUtils.findSingleFileThatEndsWith(project, QuarkusUtils.runnerSuffix(quarkusConfiguration))).fileMode("0755").build();
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir()).layer(Assembly.builder().fileSet(artifactFileSet).build()).build();
    };
    public static final QuarkusAssembly FAST_JAR = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        File quarkusAppDirectory = new File(project.getBuildDirectory(), "quarkus-app");
        if (!quarkusAppDirectory.exists()) {
            throw new IllegalStateException("The quarkus-app directory required in Quarkus Fast Jar mode was not found");
        }
        AssemblyFileSet.AssemblyFileSetBuilder libFileSet = QuarkusAssemblies.createFileSet(project).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)quarkusAppDirectory)).include("lib").fileMode("0640");
        AssemblyFileSet.AssemblyFileSetBuilder fastJarFileSet = QuarkusAssemblies.createFileSet(project).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)quarkusAppDirectory)).include("quarkus-run.jar").include("*").include("**/*").exclude("lib/**/*").exclude("lib/*").fileMode("0640");
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir()).layer(Assembly.builder().id("lib").fileSet(libFileSet.build()).build()).layer(Assembly.builder().id("fast-jar").fileSet(fastJarFileSet.build()).build()).build();
    };
    public static final QuarkusAssembly LEGACY_JAR = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        AssemblyFileSet.AssemblyFileSetBuilder libFileSet = QuarkusAssemblies.createFileSet(project).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).include("lib").fileMode("0640");
        AssemblyFileSet.AssemblyFileSetBuilder artifactFileSet = QuarkusAssemblies.createFileSet(project).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).include(QuarkusUtils.findSingleFileThatEndsWith(project, QuarkusUtils.runnerSuffix(QuarkusUtils.getQuarkusConfiguration(project)) + ".jar")).fileMode("0640");
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir()).layer(Assembly.builder().id("lib").fileSet(libFileSet.build()).build()).layer(Assembly.builder().id("artifact").fileSet(artifactFileSet.build()).build()).build();
    };
    public static final QuarkusAssembly UBER_JAR = quarkusGenerator -> {
        JavaProject project = quarkusGenerator.getContext().getProject();
        AssemblyFileSet.AssemblyFileSetBuilder fileSetBuilder = QuarkusAssemblies.createFileSet(project).directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).include(QuarkusUtils.findSingleFileThatEndsWith(project, QuarkusUtils.runnerSuffix(QuarkusUtils.getQuarkusConfiguration(project)) + ".jar")).fileMode("0640");
        return QuarkusAssemblies.createAssemblyConfiguration(quarkusGenerator.getBuildWorkdir()).layer(Assembly.builder().fileSet(fileSetBuilder.build()).build()).build();
    };

    private static AssemblyFileSet.AssemblyFileSetBuilder createFileSet(JavaProject project) {
        AssemblyFileSet.AssemblyFileSetBuilder assemblyFileSetBuilder = AssemblyFileSet.builder().outputDirectory(new File("."));
        File defaultJarFile = JKubeProjectUtil.getFinalOutputArtifact((JavaProject)project);
        if (defaultJarFile != null) {
            assemblyFileSetBuilder.exclude(defaultJarFile.getName());
        }
        return assemblyFileSetBuilder;
    }

    private static AssemblyConfiguration.AssemblyConfigurationBuilder createAssemblyConfiguration(String targetDir) {
        return AssemblyConfiguration.builder().targetDir(targetDir).excludeFinalOutputArtifact(true);
    }

    @FunctionalInterface
    public static interface QuarkusAssembly {
        public AssemblyConfiguration createAssemblyConfiguration(QuarkusGenerator var1);
    }
}

