/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleHelp;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Toolkit;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class AMenuBar
extends JMenuBar {
    private static final long serialVersionUID = -1685422450827149167L;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static final int cmdKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    private ActionManager actionMgr = null;
    private ConsoleObj conObj = null;
    private boolean displayIcons;
    private JMenuItem addItem;
    private JMenuItem connectItem;
    private JMenuItem disconnectItem;
    private JMenuItem pauseItem;
    private JMenuItem resumeItem;

    public AMenuBar(ActionManager actionMgr) {
        this(actionMgr, true);
    }

    public AMenuBar(ActionManager actionMgr, boolean displayIcons) {
        this.actionMgr = actionMgr;
        this.displayIcons = displayIcons;
        this.initGui();
    }

    public void setConsoleObj(ConsoleObj conObj) {
        this.conObj = conObj;
        this.setLabels();
        this.setIcons();
    }

    private void initGui() {
        JMenu consoleMenu = this.add(new JMenu(acr.getString("A1000")));
        consoleMenu.setMnemonic(acr.getChar("A1039"));
        JMenuItem exitItem = this.addMenuItem(consoleMenu, 8);
        exitItem.setText(acr.getString("A1002"));
        exitItem.setMnemonic(acr.getChar("A1041"));
        exitItem.setAccelerator(KeyStroke.getKeyStroke((int)acr.getChar("A1224"), cmdKey));
        JMenu editMenu = this.add(new JMenu(acr.getString("A1003")));
        editMenu.setMnemonic(acr.getChar("A1042"));
        JMenuItem deleteItem = this.addMenuItem(editMenu, 2);
        deleteItem.setText(acr.getString("A1018"));
        deleteItem.setMnemonic(acr.getChar("A1052"));
        JMenu actionsMenu = this.add(new JMenu(acr.getString("A1004")));
        actionsMenu.setMnemonic(acr.getChar("A1043"));
        this.addItem = this.addMenuItem(actionsMenu, 1);
        this.addItem.setText(acr.getString("A1012"));
        this.addItem.setMnemonic(acr.getChar("A1051"));
        this.addItem.setAccelerator(KeyStroke.getKeyStroke((int)acr.getChar("A1225"), cmdKey));
        JMenuItem purgeItem = this.addMenuItem(actionsMenu, 32768);
        purgeItem.setText(acr.getString("A1038"));
        purgeItem.setMnemonic(acr.getChar("A1059"));
        actionsMenu.add(new JSeparator());
        this.connectItem = this.addMenuItem(actionsMenu, 1024);
        this.connectItem.setText(acr.getString("A1024"));
        this.connectItem.setMnemonic(acr.getChar("A1053"));
        this.disconnectItem = this.addMenuItem(actionsMenu, 2048);
        this.disconnectItem.setText(acr.getString("A1027"));
        this.disconnectItem.setMnemonic(acr.getChar("A1054"));
        actionsMenu.add(new JSeparator());
        JMenuItem queryBrokerItem = this.addMenuItem(actionsMenu, 65536);
        queryBrokerItem.setText(acr.getString("A1505"));
        queryBrokerItem.setMnemonic(acr.getChar("A1506"));
        this.pauseItem = this.addMenuItem(actionsMenu, 256);
        this.pauseItem.setText(acr.getString("A1030"));
        this.pauseItem.setMnemonic(acr.getChar("A1055"));
        this.resumeItem = this.addMenuItem(actionsMenu, 512);
        this.resumeItem.setText(acr.getString("A1033"));
        this.resumeItem.setMnemonic(acr.getChar("A1056"));
        JMenuItem restartBrokerItem = this.addMenuItem(actionsMenu, 128);
        restartBrokerItem.setText(acr.getString("A1037"));
        restartBrokerItem.setMnemonic(acr.getChar("A1058"));
        JMenuItem shutdownBrokerItem = this.addMenuItem(actionsMenu, 64);
        shutdownBrokerItem.setText(acr.getString("A1036"));
        shutdownBrokerItem.setMnemonic(acr.getChar("A1057"));
        actionsMenu.add(new JSeparator());
        JMenuItem propsItem = this.addMenuItem(actionsMenu, 32);
        propsItem.setText(acr.getString("A1005"));
        propsItem.setMnemonic(acr.getChar("A1044"));
        JMenu viewMenu = this.add(new JMenu(acr.getString("A1006")));
        viewMenu.setMnemonic(acr.getChar("A1045"));
        JMenuItem expandItem = this.addMenuItem(viewMenu, 4096);
        expandItem.setText(acr.getString("A1007"));
        expandItem.setMnemonic(acr.getChar("A1046"));
        JMenuItem collapseItem = this.addMenuItem(viewMenu, 8192);
        collapseItem.setText(acr.getString("A1008"));
        collapseItem.setMnemonic(acr.getChar("A1047"));
        viewMenu.add(new JSeparator());
        JMenuItem refreshItem = this.addMenuItem(viewMenu, 16384);
        refreshItem.setText(acr.getString("A1009"));
        refreshItem.setMnemonic(acr.getChar("A1048"));
        this.add(Box.createGlue());
        JMenu helpMenu = this.add(new JMenu(acr.getString("A1010")));
        helpMenu.setMnemonic(acr.getChar("A1049"));
        JMenuItem overviewItem = new JMenuItem(acr.getString("A1154"));
        overviewItem.setText(acr.getString("A1106"));
        helpMenu.add(overviewItem);
        if (ConsoleHelp.helpLoaded()) {
            HelpBroker hb = ConsoleHelp.hb[0];
            HelpSet hs = ConsoleHelp.hs[0];
            overviewItem.addActionListener(ConsoleHelp.hl[0]);
            hb.enableHelp(overviewItem, "overview", hs);
        } else {
            overviewItem.setEnabled(false);
        }
        helpMenu.add(new JSeparator());
        JMenuItem aboutItem = this.addMenuItem(helpMenu, 16);
        aboutItem.setText(acr.getString("A1011"));
        aboutItem.setMnemonic(acr.getChar("A1050"));
    }

    private JMenuItem addMenuItem(JMenu menu, int actionId) {
        JMenuItem item = menu.add(this.actionMgr.getAction(actionId));
        if (!this.displayIcons) {
            item.setIcon(null);
        }
        return item;
    }

    private void setLabels() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetLabel(1, this.addItem);
        this.checkAndSetLabel(1024, this.connectItem);
        this.checkAndSetLabel(2048, this.disconnectItem);
        this.checkAndSetLabel(256, this.pauseItem);
        this.checkAndSetLabel(512, this.resumeItem);
    }

    private void checkAndSetLabel(int actionFlag, JMenuItem item) {
        String label = this.conObj.getActionLabel(actionFlag, true);
        if (label != null) {
            item.setText(label);
        }
    }

    private void setIcons() {
        if (this.conObj == null) {
            return;
        }
        this.checkAndSetIcon(1024, this.connectItem);
        this.checkAndSetIcon(2048, this.disconnectItem);
    }

    private void checkAndSetIcon(int actionFlag, JMenuItem item) {
        ImageIcon icon = this.conObj.getActionIcon(actionFlag);
        if (icon != null) {
            item.setIcon(icon);
        }
    }
}

