/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.StubArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.ProfileModifiers;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;

public class StubApiComponent
extends SystemLibraryApiComponent {
    private static final String STUB_PATH = "/org/eclipse/pde/api/tools/internal/api_stubs/";
    private static Map<String, IApiComponent> AllSystemLibraryApiComponents;

    public static IApiComponent getStubApiComponent(int eeValue) {
        String name;
        IApiComponent component;
        if (AllSystemLibraryApiComponents == null) {
            AllSystemLibraryApiComponents = new HashMap<String, IApiComponent>();
        }
        if ((component = AllSystemLibraryApiComponents.get(name = ProfileModifiers.getName(eeValue))) == null) {
            File stubFile = StubApiComponent.getFileFor(eeValue, name);
            if (stubFile == null) {
                return null;
            }
            component = new StubApiComponent(ApiBaselineManager.getManager().getWorkspaceBaseline(), stubFile.getAbsolutePath(), name);
            AllSystemLibraryApiComponents.put(name, component);
        }
        return component;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getFileFor(int eeValue, String name) {
        try {
            String lname = name;
            switch (eeValue) {
                case 1: 
                case 2: 
                case 512: 
                case 1024: 
                case 2048: {
                    lname = lname.replace('/', '_');
                    break;
                }
            }
            String stubName = String.valueOf(lname) + ".zip";
            URL stub = null;
            if (Platform.isRunning()) {
                stub = ApiPlugin.getDefault().getBundle().getResource(STUB_PATH + stubName);
                if (stub == null) {
                    return null;
                }
                stub = FileLocator.toFileURL((URL)stub);
            } else {
                stub = ApiPlugin.class.getResource(STUB_PATH + stubName);
                if (stub == null) {
                    return null;
                }
            }
            File stubFile = new File(stub.getFile());
            if (!stubFile.exists()) {
                return null;
            }
            return stubFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String[] getInstalledMetadata() {
        ArrayList<String> allEEs = new ArrayList<String>();
        int[] allEEsValues = ProfileModifiers.getAllIds();
        String name = null;
        File stubFile = null;
        int eeValue = -1;
        int i = 0;
        while (i < allEEsValues.length) {
            eeValue = allEEsValues[i];
            name = ProfileModifiers.getName(eeValue);
            switch (eeValue) {
                case 1: 
                case 2: 
                case 512: 
                case 1024: 
                case 2048: {
                    name = name.replace('/', '_');
                    break;
                }
            }
            stubFile = StubApiComponent.getFileFor(eeValue, name);
            if (stubFile != null) {
                allEEs.add(ProfileModifiers.getName(eeValue));
            }
            ++i;
        }
        Object[] result = new String[allEEs.size()];
        allEEs.toArray(result);
        Arrays.sort(result);
        return result;
    }

    private StubApiComponent(IApiBaseline baseline, String fileName, String profileName) {
        super(baseline);
        Path path = new Path(fileName);
        this.fLibraries = new LibraryLocation[]{new LibraryLocation((IPath)path, null, null)};
        this.fExecEnv = new String[]{profileName};
        this.fVersion = this.fExecEnv[0];
        this.setName(this.fExecEnv[0]);
        this.fLocation = path.toOSString();
    }

    @Override
    protected IApiDescription createApiDescription() throws CoreException {
        return null;
    }

    @Override
    protected IApiFilterStore createApiFilterStore() {
        return null;
    }

    @Override
    protected List<IApiTypeContainer> createApiTypeContainers() throws CoreException {
        ArrayList<IApiTypeContainer> libs = new ArrayList<IApiTypeContainer>(this.fLibraries.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            LibraryLocation lib = this.fLibraries[i];
            libs.add(new StubArchiveApiTypeContainer(this, lib.getSystemLibraryPath().toOSString()));
            ++i;
        }
        return libs;
    }

    @Override
    public boolean isSystemComponent() {
        return false;
    }

    public static void disposeAllCaches() {
        if (AllSystemLibraryApiComponents != null) {
            for (IApiComponent apiComponent : AllSystemLibraryApiComponents.values()) {
                apiComponent.dispose();
            }
        }
    }

    public static boolean isInstalled(int eeValue) {
        String name = ProfileModifiers.getName(eeValue);
        switch (eeValue) {
            case 1: 
            case 2: 
            case 512: 
            case 1024: 
            case 2048: {
                name = name.replace('/', '_');
                break;
            }
        }
        File stubFile = StubApiComponent.getFileFor(eeValue, name);
        return stubFile != null;
    }
}

