/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshChangeListener;
import org.eclipse.team.internal.ui.synchronize.WorkbenchAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.actions.ActionFactory;

public class RefreshUserNotificationPolicy
implements IRefreshSubscriberListener {
    private ISynchronizeParticipant participant;

    public RefreshUserNotificationPolicy(ISynchronizeParticipant participant) {
        this.participant = participant;
    }

    public void refreshStarted(final IRefreshEvent event) {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                ISynchronizeView view;
                if (event.getRefreshType() == 2 && event.getParticipant() == RefreshUserNotificationPolicy.this.participant && (view = TeamUI.getSynchronizeManager().showSynchronizeViewInActivePage()) != null) {
                    view.display(RefreshUserNotificationPolicy.this.participant);
                }
            }
        });
    }

    public ActionFactory.IWorkbenchAction refreshDone(final IRefreshEvent event) {
        if (event.getParticipant() != this.participant) {
            return null;
        }
        int severity = event.getStatus().getSeverity();
        if (severity == 8 || severity == 4) {
            return null;
        }
        return new WorkbenchAction(){

            public void run() {
                ISynchronizeView view;
                boolean prompt = event.getStatus().getCode() == 0;
                if (prompt = RefreshUserNotificationPolicy.this.handleRefreshDone(event, prompt)) {
                    RefreshUserNotificationPolicy.this.notifyIfNeededModal(event);
                }
                this.setToolTipText(this.getToolTipText());
                if (event.isLink() && (view = TeamUI.getSynchronizeManager().showSynchronizeViewInActivePage()) != null) {
                    view.display(RefreshUserNotificationPolicy.this.participant);
                }
            }

            public String getToolTipText() {
                boolean prompt;
                boolean bl = prompt = event.getStatus().getCode() == 0;
                if (prompt) {
                    return TeamUIMessages.RefreshSubscriberJob_2a;
                }
                return NLS.bind((String)TeamUIMessages.RefreshSubscriberJob_2b, (Object[])new String[]{Utils.shortenText(100, RefreshUserNotificationPolicy.this.participant.getName())});
            }
        };
    }

    private void notifyIfNeededModal(final IRefreshEvent event) {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                String title = event.getRefreshType() == 1 ? NLS.bind((String)TeamUIMessages.RefreshCompleteDialog_4a, (Object[])new String[]{Utils.getTypeName(RefreshUserNotificationPolicy.this.participant)}) : NLS.bind((String)TeamUIMessages.RefreshCompleteDialog_4, (Object[])new String[]{Utils.getTypeName(RefreshUserNotificationPolicy.this.participant)});
                MessageDialog.openInformation((Shell)Utils.getShell(null), (String)title, (String)event.getStatus().getMessage());
            }
        });
    }

    protected boolean handleRefreshDone(IRefreshEvent event, boolean prompt) {
        if (this.participant instanceof SubscriberParticipant) {
            SubscriberParticipant sp = (SubscriberParticipant)this.participant;
            SyncInfo[] infos = ((RefreshChangeListener)event.getChangeDescription()).getChanges();
            ArrayList<IResource> selectedResources = new ArrayList<IResource>();
            selectedResources.addAll(Arrays.asList(((RefreshChangeListener)event.getChangeDescription()).getResources()));
            int i = 0;
            while (i < infos.length) {
                selectedResources.add(infos[i].getLocal());
                ++i;
            }
            IResource[] resources = selectedResources.toArray(new IResource[selectedResources.size()]);
            if (resources.length == 1 && resources[0].getType() == 1) {
                IResource file = resources[0];
                SyncInfo info = sp.getSubscriberSyncInfoCollector().getSyncInfoSet().getSyncInfo(file);
                if (info != null) {
                    OpenInCompareAction.openCompareEditor(this.participant, info, null);
                    prompt = false;
                }
            }
        }
        return prompt;
    }
}

