/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.model.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.providers.IContextContainerProvider;
import org.eclipse.rcptt.core.internal.ecl.parser.Q7EclParserPlugin;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Context;

public enum DeclarationFactory {
    INSTANCE;

    private static final String ATTR_ID = "contextId";
    private static final String ATTR_CLASS = "class";
    private static final String EXT = "org.eclipse.rcptt.core.ecl.parser.context_container_provider";
    private Map<String, IContextContainerProvider> providers = new HashMap<String, IContextContainerProvider>();

    private DeclarationFactory() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT);
        int n2 = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IConfigurationElement element = iConfigurationElementArray[n3];
            try {
                this.providers.put(element.getAttribute(ATTR_ID), (IContextContainerProvider)element.createExecutableExtension(ATTR_CLASS));
            }
            catch (Exception e) {
                Q7EclParserPlugin.logErr(e, "Error loading context declaration provider from plugin %s", element.getDeclaringExtension().getUniqueIdentifier());
            }
            ++n3;
        }
    }

    public IDeclContainer safeFromContext(IContext context) {
        try {
            return this.fromContext(context);
        }
        catch (Exception e) {
            Q7EclParserPlugin.logErr(e, "Error loading declarations from context", new Object[0]);
            return null;
        }
    }

    public IDeclContainer fromContext(IContext context) throws ModelException {
        Context content = (Context)context.getNamedElement();
        ContextType type = ContextTypeManager.getInstance().getTypeByContext(content);
        IContextContainerProvider provider = this.providers.get(type.getId());
        if (provider != null) {
            return provider.create(content);
        }
        return null;
    }
}

