/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.expandbar.runtime.internal;

import org.eclipse.rcptt.expandbar.runtime.internal.ExpandBarRecordingHelper;
import org.eclipse.rcptt.expandbar.runtime.internal.ItemLocation;
import org.eclipse.rcptt.tesla.core.protocol.BasicUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.ItemUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.IWidgetClassifierExtension;
import org.eclipse.rcptt.tesla.recording.core.swt.IWidgetLocatorExtension;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTWidgetLocator;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;

public class ExpandBarWidgetLocatorExtension
implements IWidgetLocatorExtension {
    private SWTWidgetLocator locator;

    public ExpandBarWidgetLocatorExtension(SWTWidgetLocator locator) {
        this.locator = locator;
    }

    public FindResult findElement(SWTUIElement widget, boolean unknownAllowed, boolean alwaysFindLeaf, boolean supportEclipseWorkbench) {
        BasicRecordingHelper.ElementEntry entry = ExpandBarRecordingHelper.getHelper().get(widget);
        if (entry != null && !alwaysFindLeaf) {
            return new FindResult(widget, entry.getElement());
        }
        BasicUIElement found = null;
        org.eclipse.swt.widgets.Widget realWidget = widget.unwrap();
        if (realWidget instanceof ExpandItem) {
            found = this.findExpandItem((ExpandItem)realWidget);
        }
        boolean cfr_ignored_0 = realWidget instanceof ExpandBar;
        if (found != null) {
            ExpandBarRecordingHelper.getHelper().put(widget, new BasicRecordingHelper.ElementEntry(found.getElement()));
            return new FindResult(widget, found.getElement());
        }
        return null;
    }

    private BasicUIElement findExpandItem(ExpandItem item) {
        ExpandBar bar = item.getParent();
        BasicUIElement expandBar = this.findExpandBar(bar);
        UISelector itemSelector = new UISelector(ElementKind.Item, (IUIPlayer)this.locator.getRecorder(), ItemUIElement.class).parent(expandBar.getElement());
        this.locator.getRecorder().setControls(new Widget[]{SWTModelMapper.map((SWTUIElement)this.locator.getPlayer().wrap((Object)item))});
        return itemSelector.path(new String[]{ItemLocation.fromItem(item).toPathFragment()}).find();
    }

    private BasicUIElement findExpandBar(ExpandBar expandBar) {
        FindResult barResult = this.locator.findElement(this.locator.getPlayer().wrap((Object)expandBar), false, false, false);
        return new BasicUIElement(barResult.element, (UIPlayer)this.locator.getRecorder());
    }

    public IWidgetClassifierExtension getWidgetClassifierExtension() {
        return null;
    }
}

