/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.concurrent.locks.StampedLongAdderLockManager;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.PersistentSetFactory;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistentSet<T extends Serializable>
extends AbstractSet<T> {
    private static final Logger logger = LoggerFactory.getLogger(PersistentSet.class);
    private PersistentSetFactory<T> factory;
    private final int dbi;
    private int size;

    public PersistentSet(PersistentSetFactory<T> factory, int dbi) {
        this.factory = factory;
        this.dbi = dbi;
    }

    @Override
    public synchronized void clear() {
        if (this.factory.writeTxn != 0L) {
            LMDB.mdb_txn_abort((long)this.factory.writeTxn);
            this.factory.writeTxn = 0L;
        }
        try {
            LmdbUtil.E(LMDB.mdb_txn_begin((long)this.factory.env, (long)0L, (int)0, (PointerBuffer)this.factory.writeTxnPp));
            this.factory.writeTxn = this.factory.writeTxnPp.get(0);
            LMDB.mdb_drop((long)this.factory.writeTxn, (int)this.dbi, (boolean)false);
            this.factory.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            this.factory.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ElementIterator(this.dbi);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T element) {
        try {
            return this.update(element, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean remove(Object element) {
        try {
            return this.update(element, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized boolean update(Object element, boolean add) throws IOException, InterruptedException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int rc;
            if (this.factory.writeTxn == 0L) {
                LmdbUtil.E(LMDB.mdb_txn_begin((long)this.factory.env, (long)0L, (int)0, (PointerBuffer)this.factory.writeTxnPp));
                this.factory.writeTxn = this.factory.writeTxnPp.get(0);
            }
            this.factory.ensureResize();
            MDBVal keyVal = MDBVal.malloc((MemoryStack)stack);
            MDBVal dataVal = MDBVal.calloc((MemoryStack)stack);
            byte[] data = this.write((Serializable)element);
            ByteBuffer keyBuf = stack.malloc(data.length);
            keyBuf.put(data);
            keyBuf.flip();
            keyVal.mv_data(keyBuf);
            if (add) {
                rc = LMDB.mdb_put((long)this.factory.writeTxn, (int)this.dbi, (MDBVal)keyVal, (MDBVal)dataVal, (int)16);
                if (rc == 0) {
                    ++this.size;
                    boolean bl = true;
                    return bl;
                }
                if (rc == -30792) {
                    this.factory.ensureResize();
                    if (LMDB.mdb_put((long)this.factory.writeTxn, (int)this.dbi, (MDBVal)keyVal, (MDBVal)dataVal, (int)16) == 0) {
                        ++this.size;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                logger.debug("Failed to add element due to error {}: {}", (Object)LMDB.mdb_strerror((int)rc), element);
            } else {
                rc = LMDB.mdb_del((long)this.factory.writeTxn, (int)this.dbi, (MDBVal)keyVal, (MDBVal)dataVal);
                if (rc == 0) {
                    --this.size;
                    boolean bl = true;
                    return bl;
                }
                if (rc == -30792) {
                    this.factory.ensureResize();
                    if (LMDB.mdb_del((long)this.factory.writeTxn, (int)this.dbi, (MDBVal)keyVal, (MDBVal)dataVal) == 0) {
                        --this.size;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                logger.debug("Failed to remove element due to error {}: {}", (Object)LMDB.mdb_strerror((int)rc), element);
            }
            boolean bl = false;
            return bl;
        }
    }

    protected byte[] write(T element) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(element);
        out.close();
        return baos.toByteArray();
    }

    protected T read(ByteBuffer buffer) throws IOException {
        try {
            return (T)((Serializable)new ObjectInputStream(new ByteBufferBackedInputStream(buffer)).readObject());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }

    public class ByteBufferBackedInputStream
    extends InputStream {
        final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }

    private class ElementIterator
    implements Iterator<T> {
        private final MDBVal keyData = MDBVal.malloc();
        private final MDBVal valueData = MDBVal.malloc();
        private final long cursor;
        private final StampedLongAdderLockManager txnLockManager;
        private TxnManager.Txn txnRef;
        private long txnRefVersion;
        private T next;
        private T current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ElementIterator(int dbi) {
            try {
                this.txnRef = PersistentSet.this.factory.txnManager.createReadTxn();
                this.txnLockManager = this.txnRef.lockManager();
                long readStamp = this.txnLockManager.readLock();
                try {
                    this.txnRefVersion = this.txnRef.version();
                    try (MemoryStack stack = MemoryStack.stackPush();){
                        PointerBuffer pp = stack.mallocPointer(1);
                        LmdbUtil.E(LMDB.mdb_cursor_open((long)this.txnRef.get(), (int)dbi, (PointerBuffer)pp));
                        this.cursor = pp.get(0);
                    }
                }
                finally {
                    this.txnLockManager.unlockRead(readStamp);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null && this.txnRef != null) {
                try {
                    this.next = this.computeNext();
                }
                catch (Exception e) {
                    this.next = null;
                }
                if (this.next == null) {
                    this.close();
                }
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = null;
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T computeNext() throws IOException, InterruptedException {
            long readStamp = this.txnLockManager.readLock();
            try {
                Object t;
                block13: {
                    if (this.txnRefVersion != this.txnRef.version()) {
                        LMDB.mdb_cursor_renew((long)this.txnRef.get(), (long)this.cursor);
                        MemoryStack stack = MemoryStack.stackPush();
                        this.keyData.mv_data(stack.bytes(PersistentSet.this.write(this.current)));
                        if (LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)15) == 0 || LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17) != 0) break block13;
                        Object t2 = PersistentSet.this.read(this.keyData.mv_data());
                        return t2;
                        finally {
                            if (stack != null) {
                                stack.close();
                            }
                        }
                    }
                }
                if (LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8) == 0) {
                    t = PersistentSet.this.read(this.keyData.mv_data());
                    return t;
                }
                this.close();
                t = null;
                return t;
            }
            finally {
                this.txnLockManager.unlockRead(readStamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.txnRef != null) {
                long readStamp;
                this.keyData.close();
                this.valueData.close();
                try {
                    readStamp = this.txnLockManager.readLock();
                }
                catch (InterruptedException e) {
                    throw new SailException(e);
                }
                try {
                    LMDB.mdb_cursor_close((long)this.cursor);
                    this.txnRef.close();
                    this.txnRef = null;
                }
                finally {
                    this.txnLockManager.unlockRead(readStamp);
                }
            }
        }

        @Override
        public void remove() {
            PersistentSet.this.remove(this.current);
        }
    }
}

