/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.loader;

import java.io.InputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.document.JsonDocument;
import no.hasmac.jsonld.document.RdfDocument;
import no.hasmac.jsonld.http.media.MediaType;
import no.hasmac.jsonld.loader.DocumentReader;
import no.hasmac.rdf.Rdf;

class DocumentResolver {
    private static final Logger LOGGER = Logger.getLogger(DocumentResolver.class.getName());
    private MediaType fallbackContentType = null;

    public DocumentReader<InputStream> getReader(MediaType contentType) throws JsonLdError {
        return DocumentResolver.findReader(contentType).or(() -> {
            if (this.fallbackContentType != null) {
                LOGGER.log(Level.WARNING, "Content type [{0}] is not acceptable, trying again with [{1}].", new Object[]{contentType, this.fallbackContentType});
                return DocumentResolver.findReader(this.fallbackContentType);
            }
            return Optional.empty();
        }).orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported media type '" + String.valueOf(contentType) + "'. Supported content types are [" + String.valueOf(MediaType.JSON_LD) + ", " + String.valueOf(MediaType.JSON) + ", +json, " + Rdf.canRead().stream().map(MediaType::toString).collect(Collectors.joining(", ")) + "]"));
    }

    public void setFallbackContentType(MediaType fallbackContentType) {
        this.fallbackContentType = fallbackContentType;
    }

    private static Optional<DocumentReader<InputStream>> findReader(MediaType type) {
        if (type == null) {
            return Optional.empty();
        }
        if (JsonDocument.accepts(type)) {
            return Optional.of(is -> JsonDocument.of(type, is));
        }
        if (RdfDocument.accepts(type)) {
            return Optional.of(is -> RdfDocument.of(type, is));
        }
        return Optional.empty();
    }
}

