/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.sail.InterruptedSailException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlQueryParserCache;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingletonBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public abstract class AbstractBulkJoinPlanNode
implements PlanNode {
    public static final List<StatementMatcher.Variable> DEFAULT_VARS = List.of(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"));
    public static final String BINDING_NAME = "a";
    protected static final int BULK_SIZE = 1000;
    private final List<StatementMatcher.Variable> vars;
    private final String varsQueryString;
    StackTraceElement[] stackTrace;
    protected Function<BindingSet, ValidationTuple> mapper;
    ValidationExecutionLogger validationExecutionLogger;

    public AbstractBulkJoinPlanNode(List<StatementMatcher.Variable> vars) {
        this.vars = vars;
        this.varsQueryString = vars.stream().map(StatementMatcher.Variable::asSparqlVariable).reduce((a, b) -> a + " " + b).orElseThrow();
        this.stackTrace = Thread.currentThread().getStackTrace();
    }

    TupleExpr parseQuery(String query) {
        query = query.replace("#VALUES_INJECTION_POINT#", "\nVALUES (?a) {}\n");
        String completeQuery = "select distinct " + this.varsQueryString + " where {\nVALUES (?a) {}\n" + query + "\n}";
        return SparqlQueryParserCache.get(completeQuery);
    }

    void runQuery(Collection<ValidationTuple> left, ArrayDeque<ValidationTuple> right, SailConnection connection, TupleExpr parsedQuery, Dataset dataset, Resource[] dataGraph, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection) {
        List<BindingSet> newBindindingSet = this.buildBindingSets(left, connection, skipBasedOnPreviousConnection, previousStateConnection, dataGraph);
        if (!newBindindingSet.isEmpty()) {
            this.updateQuery(parsedQuery, newBindindingSet);
            if (Thread.currentThread().isInterrupted()) {
                Thread.currentThread().interrupt();
                throw new InterruptedSailException();
            }
            this.executeQuery(right, connection, dataset, parsedQuery);
        }
    }

    private void executeQuery(ArrayDeque<ValidationTuple> right, SailConnection connection, Dataset dataset, TupleExpr parsedQuery) {
        try (Stream stream = connection.evaluate(parsedQuery, dataset, EmptyBindingSet.getInstance(), true).stream();){
            stream.map(this.mapper).sorted(ValidationTuple::compareActiveTarget).forEachOrdered(right::addFirst);
        }
    }

    private void updateQuery(TupleExpr parsedQuery, final List<BindingSet> newBindindingSet) {
        parsedQuery.visit((QueryModelVisitor)new AbstractSimpleQueryModelVisitor<RuntimeException>(false){

            public void meet(BindingSetAssignment node) {
                Set bindingNames = node.getBindingNames();
                if (bindingNames.size() == 1 && bindingNames.contains(AbstractBulkJoinPlanNode.BINDING_NAME)) {
                    node.setBindingSets((Iterable)newBindindingSet);
                }
                super.meet(node);
            }
        });
    }

    private List<BindingSet> buildBindingSets(Collection<ValidationTuple> left, SailConnection connection, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, Resource[] dataGraph) {
        return left.stream().filter(tuple -> {
            boolean hasStatement;
            if (!skipBasedOnPreviousConnection) {
                return true;
            }
            if (Thread.currentThread().isInterrupted()) {
                Thread.currentThread().interrupt();
                throw new InterruptedSailException("Thread was interrupted while checking previous state connection.");
            }
            if (!connection.isOpen() || !connection.isActive()) {
                throw new SailException("Connection is not active");
            }
            if (!tuple.getActiveTarget().isResource()) {
                hasStatement = previousStateConnection.hasStatement(null, null, tuple.getActiveTarget(), true, dataGraph);
            } else {
                boolean bl = hasStatement = previousStateConnection.hasStatement((Resource)tuple.getActiveTarget(), null, null, true, dataGraph) || previousStateConnection.hasStatement(null, null, tuple.getActiveTarget(), true, dataGraph);
            }
            if (!hasStatement && this.validationExecutionLogger.isEnabled()) {
                this.validationExecutionLogger.log(this.depth(), this.getClass().getSimpleName() + ":IgnoredDueToPreviousStateConnection", (ValidationTuple)tuple, this, this.getId(), null);
            }
            return hasStatement;
        }).map(ValidationTuple::getActiveTarget).map(r -> new SingletonBindingSet(BINDING_NAME, (Value)r)).collect(Collectors.toList());
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBulkJoinPlanNode that = (AbstractBulkJoinPlanNode)o;
        return this.mapper.equals(that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

