/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class ProtocolExceptionResolver
implements HandlerExceptionResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        Throwable temp;
        this.logger.debug("ProtocolExceptionResolver.resolveException() called");
        HashMap<String, Object> model = new HashMap<String, Object>();
        int statusCode = 500;
        String errMsg = exception.getMessage();
        if (exception instanceof HTTPException) {
            HTTPException httpExc = (HTTPException)exception;
            statusCode = httpExc.getStatusCode();
            if (exception instanceof ClientHTTPException) {
                this.logger.info("Client sent bad request ( " + statusCode + ")", (Throwable)exception);
            } else {
                this.logger.error("Error while handling request (" + statusCode + ")", (Throwable)exception);
            }
        } else {
            this.logger.error("Error while handling request", (Throwable)exception);
        }
        int depth = 10;
        for (temp = exception; !(temp instanceof ValidationException) && depth-- != 0 && temp != null; temp = temp.getCause()) {
        }
        if (temp instanceof ValidationException) {
            Model validationReportModel = ((ValidationException)((Object)temp)).validationReportAsModel();
            StringWriter stringWriter = new StringWriter();
            Rio.write((Iterable<Statement>)validationReportModel, (Writer)stringWriter, RDFFormat.RDFJSON);
            statusCode = 409;
            errMsg = stringWriter.toString();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/shacl-validation-report+rdf+json");
            model.put("headers", headers);
        }
        model.put("sc", statusCode);
        model.put("content", errMsg);
        return new ModelAndView((View)SimpleResponseView.getInstance(), model);
    }
}

