/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.resolver;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.resolver.RepositoryResolver;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class DefaultRepositoryResolver
implements RepositoryResolver {
    private final RepositoryManager repositoryManager;

    public DefaultRepositoryResolver(RepositoryManager repMan) {
        this.repositoryManager = repMan;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @Override
    public RepositoryConfig getRepositoryConfig(String repId, Model model) {
        return RepositoryConfigUtil.getRepositoryConfig(model, repId);
    }

    @Override
    public String getRepositoryID(HttpServletRequest request) {
        return RepositoryInterceptor.getRepositoryID(request);
    }

    @Override
    public RepositoryConnection getRepositoryConnection(HttpServletRequest request, Repository repository) {
        RepositoryConnection conn = repository.getConnection();
        conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        return conn;
    }

    @Override
    public Repository getRepository(HttpServletRequest request) {
        return RepositoryInterceptor.getRepository(request);
    }
}

