/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class LazyMutableClosableIteration
implements CloseableIteration<BindingSet> {
    protected final CloseableIteration<BindingSet> inner;
    protected List<BindingSet> consumed = new ArrayList<BindingSet>();
    protected volatile int cursorIdx = -1;

    public LazyMutableClosableIteration(CloseableIteration<BindingSet> inner) {
        this.inner = inner;
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (this.cursorIdx == -1) {
            return this.inner.hasNext();
        }
        if (this.cursorIdx >= this.consumed.size()) {
            return this.inner.hasNext();
        }
        return this.cursorIdx < this.consumed.size();
    }

    public BindingSet next() throws QueryEvaluationException {
        if (this.cursorIdx == -1 || this.cursorIdx >= this.consumed.size()) {
            BindingSet next = (BindingSet)this.inner.next();
            this.consumed.add(next);
            return next;
        }
        return this.consumed.get(this.cursorIdx++);
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("Removal not supported.");
    }

    public void close() throws QueryEvaluationException {
        this.inner.close();
    }

    public void resetCursor() {
        this.cursorIdx = 0;
    }
}

