/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction0;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteBooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteBooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ByteBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ByteBooleanMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableByteBooleanMap;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBooleanPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.primitive.ByteBooleanMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableBooleanValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableByteKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableByteKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedByteBooleanMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableByteBooleanMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ByteBooleanHashMap
extends AbstractMutableBooleanValuesMap
implements MutableByteBooleanMap,
MutableByteKeysMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    @Deprecated
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 1;
    private static final int INITIAL_LINEAR_PROBE = 32;
    private byte[] keys;
    private BitSet values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableBooleanValuesMap.SentinelValues sentinelValues;

    public ByteBooleanHashMap() {
        this.allocateTable(16);
    }

    public ByteBooleanHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public ByteBooleanHashMap(ByteBooleanMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    @Deprecated
    public ByteBooleanHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity);
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableBooleanValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected boolean getEmptyValue() {
        return false;
    }

    @Override
    protected int getTableSize() {
        return this.keys.length;
    }

    @Override
    protected boolean getValueAtIndex(int index) {
        return this.values.get(index);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ByteBooleanHashMap.isEmptyKey(this.keys[index]) && !ByteBooleanHashMap.isRemovedKey(this.keys[index]);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public MutableByteBooleanMap asUnmodifiable() {
        return new UnmodifiableByteBooleanMap(this);
    }

    public MutableByteBooleanMap asSynchronized() {
        return new SynchronizedByteBooleanMap(this);
    }

    public ImmutableByteBooleanMap toImmutable() {
        return ByteBooleanMaps.immutable.withAll((ByteBooleanMap)this);
    }

    public static ByteBooleanHashMap newWithKeysValues(byte key1, boolean value1) {
        return new ByteBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static ByteBooleanHashMap newWithKeysValues(byte key1, boolean value1, byte key2, boolean value2) {
        return new ByteBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ByteBooleanHashMap newWithKeysValues(byte key1, boolean value1, byte key2, boolean value2, byte key3, boolean value3) {
        return new ByteBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ByteBooleanHashMap newWithKeysValues(byte key1, boolean value1, byte key2, boolean value2, byte key3, boolean value3, byte key4, boolean value4) {
        return new ByteBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public ByteBooleanHashMap withKeyValue(byte key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public ByteBooleanHashMap withKeysValues(byte key1, boolean value1, byte key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteBooleanHashMap withKeysValues(byte key1, boolean value1, byte key2, boolean value2, byte key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteBooleanHashMap withKeysValues(byte key1, boolean value1, byte key2, boolean value2, byte key3, boolean value3, byte key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ByteBooleanHashMap withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public ByteBooleanHashMap withoutAllKeys(ByteIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteBooleanHashMap.isEmptyKey(key) && !ByteBooleanHashMap.isRemovedKey(key);
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(byte element) {
        int index = this.spreadAndMask(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spreadAndMask(byte element) {
        return this.mask(element);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, (byte)0);
        this.values.clear();
    }

    public void put(byte key, boolean value) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.getSentinelValues() == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
            }
            this.getSentinelValues().containsZeroKey = true;
            this.getSentinelValues().zeroValue = value;
            return;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
            }
            this.getSentinelValues().containsOneKey = true;
            this.getSentinelValues().oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, value);
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(ByteBooleanMap map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(ByteBooleanToBooleanFunction function) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                this.getSentinelValues().zeroValue = function.valueOf((byte)0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                this.getSentinelValues().oneValue = function.valueOf((byte)1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            this.values.set(i, function.valueOf(this.keys[i], this.getValueAtIndex(i)));
        }
    }

    @Override
    public boolean containsKey(byte key) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            return this.getSentinelValues() != null && this.getSentinelValues().containsZeroKey;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            return this.getSentinelValues() != null && this.getSentinelValues().containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(boolean value) {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(this.keys[i]) || this.getValueAtIndex(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean get(byte key) {
        return this.getIfAbsent(key, this.getEmptyValue());
    }

    public boolean getIfAbsent(byte key, boolean ifAbsent) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return ifAbsent;
            }
            return this.getSentinelValues().zeroValue;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return ifAbsent;
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.isNonSentinelAtIndex(index)) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(byte key) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.getSentinelValues().zeroValue;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.isNonSentinelAtIndex(index)) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(byte key, boolean value) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPut(byte key, BooleanFunction0 function) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(byte key, BooleanFunction<? super P> function, P parameter) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.booleanValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPutWithKey(byte key, ByteToBooleanFunction function) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean updateValue(byte key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.getSentinelValues().containsZeroKey) {
                this.getSentinelValues().zeroValue = function.valueOf(this.getSentinelValues().zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.getSentinelValues().zeroValue;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.getSentinelValues().containsOneKey) {
                this.getSentinelValues().oneValue = function.valueOf(this.getSentinelValues().oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, function.valueOf(this.values.get(index)));
            return this.values.get(index);
        }
        boolean value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(byte key, boolean value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public void removeKey(byte key) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values.set(index, this.getEmptyValue());
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(byte key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(byte key, boolean value) {
        if (ByteBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return value;
            }
            boolean oldValue = this.getSentinelValues().zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ByteBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return value;
            }
            boolean oldValue = this.getSentinelValues().oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            boolean oldValue = this.values.get(index);
            this.values.set(index, this.getEmptyValue());
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteBooleanMap)) {
            return false;
        }
        ByteBooleanMap other = (ByteBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (this.getSentinelValues().containsZeroKey && (!other.containsKey((byte)0) || this.getSentinelValues().zeroValue != other.getOrThrow((byte)0))) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && (!other.containsKey((byte)1) || this.getSentinelValues().oneValue != other.getOrThrow((byte)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.isNonSentinelAtIndex(i) || other.containsKey(this.keys[i]) && this.getValueAtIndex(i) == other.getOrThrow(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0 ^ (this.getSentinelValues().zeroValue ? 1231 : 1237);
            }
            if (this.getSentinelValues().containsOneKey) {
                result += 1 ^ (this.getSentinelValues().oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.getValueAtIndex(i) ? 1231 : 1237);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                appendable.append(0).append("=").append(this.getSentinelValues().zeroValue);
                first = false;
            }
            if (this.getSentinelValues().containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.getSentinelValues().oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.keys[i]).append("=").append(this.getValueAtIndex(i));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableBooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value((byte)0);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (byte key : this.keys) {
            if (!ByteBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(ByteBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value((byte)0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value((byte)1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.getValueAtIndex(i));
        }
    }

    public ByteBooleanHashMap select(ByteBooleanPredicate predicate) {
        ByteBooleanHashMap result = new ByteBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((byte)0, this.getSentinelValues().zeroValue)) {
                result.put((byte)0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((byte)1, this.getSentinelValues().oneValue)) {
                result.put((byte)1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.getValueAtIndex(i))) continue;
            result.put(this.keys[i], this.getValueAtIndex(i));
        }
        return result;
    }

    public ByteBooleanHashMap reject(ByteBooleanPredicate predicate) {
        ByteBooleanHashMap result = new ByteBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept((byte)0, this.getSentinelValues().zeroValue)) {
                result.put((byte)0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept((byte)1, this.getSentinelValues().oneValue)) {
                result.put((byte)1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.getValueAtIndex(i))) continue;
            result.put(this.keys[i], this.getValueAtIndex(i));
        }
        return result;
    }

    public LazyByteIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ByteBooleanPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(0.5f);
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                out.writeByte(0);
                out.writeBoolean(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                out.writeByte(1);
                out.writeBoolean(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeBoolean(this.getValueAtIndex(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        in.readFloat();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readBoolean());
        }
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ byte[] access$302(ByteBooleanHashMap x0, byte[] x1) {
        x0.keys = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ByteBooleanPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ByteBooleanPair> procedure) {
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ByteBooleanHashMap.this.getSentinelValues().zeroValue));
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ByteBooleanHashMap.this.getSentinelValues().oneValue));
                }
            }
            for (int i = 0; i < ByteBooleanHashMap.this.keys.length; ++i) {
                if (!ByteBooleanHashMap.isNonSentinel(ByteBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteBooleanHashMap.this.keys[i], ByteBooleanHashMap.this.getValueAtIndex(i)));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ByteBooleanPair> objectIntProcedure) {
            int index = 0;
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)0, ByteBooleanHashMap.this.getSentinelValues().zeroValue), index);
                    ++index;
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)1, ByteBooleanHashMap.this.getSentinelValues().oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ByteBooleanHashMap.this.keys.length; ++i) {
                if (!ByteBooleanHashMap.isNonSentinel(ByteBooleanHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ByteBooleanHashMap.this.keys[i], ByteBooleanHashMap.this.getValueAtIndex(i)), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ByteBooleanPair, ? super P> procedure, P parameter) {
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ByteBooleanHashMap.this.getSentinelValues().zeroValue), parameter);
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ByteBooleanHashMap.this.getSentinelValues().oneValue), parameter);
                }
            }
            for (int i = 0; i < ByteBooleanHashMap.this.keys.length; ++i) {
                if (!ByteBooleanHashMap.isNonSentinel(ByteBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteBooleanHashMap.this.keys[i], ByteBooleanHashMap.this.getValueAtIndex(i)), parameter);
            }
        }

        public Iterator<ByteBooleanPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ByteBooleanPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ByteBooleanPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ByteBooleanHashMap.this.containsKey((byte)0)) {
                        return PrimitiveTuples.pair((byte)0, ByteBooleanHashMap.this.getSentinelValues().zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ByteBooleanHashMap.this.containsKey((byte)1)) {
                        return PrimitiveTuples.pair((byte)1, ByteBooleanHashMap.this.getSentinelValues().oneValue);
                    }
                }
                byte[] keys = ByteBooleanHashMap.this.keys;
                while (!ByteBooleanHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ByteBooleanPair result = PrimitiveTuples.pair(keys[this.position], ByteBooleanHashMap.this.values.get(this.position));
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ByteBooleanHashMap.this.size();
            }
        }
    }

    private class KeySetIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean removed = true;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteBooleanHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.removed = false;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteBooleanHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteBooleanHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            byte[] keys = ByteBooleanHashMap.this.keys;
            while (!ByteBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            ByteBooleanHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.removed = true;
        }
    }

    private class ValuesCollection
    extends AbstractMutableBooleanValuesMap.AbstractBooleanValuesCollection {
        private ValuesCollection() {
            super(ByteBooleanHashMap.this);
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteBooleanHashMap.this.sentinelValues != null) {
                    if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                        appendable.append(String.valueOf(ByteBooleanHashMap.this.getSentinelValues().zeroValue));
                        first = false;
                    }
                    if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(ByteBooleanHashMap.this.getSentinelValues().oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < ByteBooleanHashMap.this.keys.length; ++i) {
                    if (!ByteBooleanHashMap.this.isNonSentinelAtIndex(i)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ByteBooleanHashMap.this.getValueAtIndex(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public MutableBooleanIterator booleanIterator() {
            return ByteBooleanHashMap.this.booleanIterator();
        }

        public boolean remove(boolean item) {
            int oldSize = ByteBooleanHashMap.this.size();
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey && item == ByteBooleanHashMap.this.getSentinelValues().zeroValue) {
                    ByteBooleanHashMap.this.removeKey((byte)0);
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey && item == ByteBooleanHashMap.this.getSentinelValues().oneValue) {
                    ByteBooleanHashMap.this.removeKey((byte)1);
                }
            }
            for (int i = 0; i < ByteBooleanHashMap.this.keys.length; ++i) {
                if (!ByteBooleanHashMap.isNonSentinel(ByteBooleanHashMap.this.keys[i]) || item != ByteBooleanHashMap.this.getValueAtIndex(i)) continue;
                ByteBooleanHashMap.this.removeKey(ByteBooleanHashMap.this.keys[i]);
            }
            return oldSize != ByteBooleanHashMap.this.size();
        }

        public boolean retainAll(BooleanIterable source) {
            int oldSize = ByteBooleanHashMap.this.size();
            Object sourceSet = source instanceof BooleanSet ? (BooleanSet)source : source.toSet();
            ByteBooleanHashMap retained = ByteBooleanHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$59afc9f8$1((BooleanSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                ByteBooleanHashMap.access$302(ByteBooleanHashMap.this, retained.keys);
                ByteBooleanHashMap.this.values = retained.values;
                ByteBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                ByteBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        private static /* synthetic */ boolean lambda$retainAll$59afc9f8$1(BooleanSet sourceSet, byte key, boolean value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySet
    extends AbstractMutableByteKeySet {
        private KeySet() {
        }

        @Override
        protected byte getKeyAtIndex(int index) {
            return ByteBooleanHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return ByteBooleanHashMap.this.keys.length;
        }

        @Override
        protected MutableByteKeysMap getOuter() {
            return ByteBooleanHashMap.this;
        }

        @Override
        protected AbstractMutableBooleanValuesMap.SentinelValues getSentinelValues() {
            return ByteBooleanHashMap.this.sentinelValues;
        }

        public MutableByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = ByteBooleanHashMap.this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            ByteBooleanHashMap retained = ByteBooleanHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$4bbed9dc$1((ByteSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                ByteBooleanHashMap.access$302(ByteBooleanHashMap.this, retained.keys);
                ByteBooleanHashMap.this.values = retained.values;
                ByteBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                ByteBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(byte ... source) {
            return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
        }

        public ByteSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public MutableByteSet newEmpty() {
            return new ByteHashSet();
        }

        private static /* synthetic */ boolean lambda$retainAll$4bbed9dc$1(ByteSet sourceSet, byte key, boolean value) {
            return sourceSet.contains(key);
        }
    }

    private class KeysView
    extends AbstractLazyByteIterable {
        private KeysView() {
        }

        @Override
        public boolean isEmpty() {
            return ByteBooleanHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ByteBooleanHashMap.this.notEmpty();
        }

        @Override
        public int size() {
            return ByteBooleanHashMap.this.size();
        }

        @Override
        public boolean contains(byte key) {
            return ByteBooleanHashMap.this.containsKey(key);
        }

        @Override
        public boolean containsAll(byte ... keys) {
            for (byte key : keys) {
                if (ByteBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(ByteIterable source) {
            return source.allSatisfy(ByteBooleanHashMap.this::containsKey);
        }

        public ByteIterator byteIterator() {
            return new UnmodifiableByteIterator((ByteIterator)new KeySetIterator());
        }

        public void each(ByteProcedure procedure) {
            ByteBooleanHashMap.this.forEachKey(procedure);
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteBooleanHashMap.this.sentinelValues != null) {
                    if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteBooleanHashMap.this.keys) {
                    if (!ByteBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int count(BytePredicate predicate) {
            int count = 0;
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept((byte)0)) {
                    ++count;
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept((byte)1)) {
                    ++count;
                }
            }
            for (byte key : ByteBooleanHashMap.this.keys) {
                if (!ByteBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteBooleanHashMap.this.keys) {
                if (!ByteBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteBooleanHashMap.this.keys) {
                if (!ByteBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(BytePredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        @Override
        public byte detectIfNone(BytePredicate predicate, byte value) {
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteBooleanHashMap.this.keys) {
                if (!ByteBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        @Override
        public long sum() {
            long result = 0L;
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    result += 0L;
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    ++result;
                }
            }
            for (byte key : ByteBooleanHashMap.this.keys) {
                if (!ByteBooleanHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        @Override
        public byte max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ByteIterator iterator = this.byteIterator();
            byte max = iterator.next();
            while (iterator.hasNext()) {
                byte value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        @Override
        public byte min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            ByteIterator iterator = this.byteIterator();
            byte min = iterator.next();
            while (iterator.hasNext()) {
                byte value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        @Override
        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        @Override
        public byte[] toArray() {
            int size = ByteBooleanHashMap.this.size();
            final byte[] result = new byte[size];
            ByteBooleanHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (ByteBooleanHashMap.this.sentinelValues != null) {
                if (ByteBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    result = function.valueOf(result, (byte)0);
                }
                if (ByteBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    result = function.valueOf(result, (byte)1);
                }
            }
            for (int i = 0; i < ByteBooleanHashMap.this.keys.length; ++i) {
                if (!ByteBooleanHashMap.isNonSentinel(ByteBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, ByteBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        @Override
        public MutableByteList toList() {
            return ByteArrayList.newList((ByteIterable)this);
        }

        @Override
        public MutableByteSet toSet() {
            return ByteHashSet.newSet((ByteIterable)this);
        }

        @Override
        public MutableByteBag toBag() {
            return ByteHashBag.newBag((ByteIterable)this);
        }
    }

    private class InternalBooleanIterator
    implements MutableBooleanIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteBooleanHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return ByteBooleanHashMap.this.getSentinelValues().zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteBooleanHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return ByteBooleanHashMap.this.getSentinelValues().oneValue;
                }
            }
            byte[] keys = ByteBooleanHashMap.this.keys;
            while (!ByteBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            boolean result = ByteBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteBooleanHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

