/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import java.io.File;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointClassification;
import org.eclipse.rdf4j.federated.endpoint.ManagedRepositoryEndpoint;
import org.eclipse.rdf4j.federated.endpoint.provider.EndpointProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.NativeRepositoryInformation;
import org.eclipse.rdf4j.federated.endpoint.provider.SailSourceEvaluationStrategyFactory;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeStoreProvider
implements EndpointProvider<NativeRepositoryInformation> {
    private static final Logger log = LoggerFactory.getLogger(NativeStoreProvider.class);
    private final File baseDir;

    public NativeStoreProvider(File baseDir) {
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint loadEndpoint(NativeRepositoryInformation repoInfo) throws FedXException {
        File store = new File(repoInfo.getLocation());
        if (store.isAbsolute()) {
            if (!store.isDirectory()) {
                throw new FedXRuntimeException("Store does not exist at '" + repoInfo.getLocation() + ": " + store.getAbsolutePath() + "'.");
            }
            log.debug("Loading Native store from " + store.getAbsolutePath());
        } else {
            if (this.baseDir == null) {
                throw new FedXException("Base directory not defined. Use FedXFactory for base directory initialization.");
            }
            store = new File(this.baseDir, "repositories/" + repoInfo.getLocation());
            if (store.isDirectory()) {
                log.debug("Loading existing native store from " + store.getAbsolutePath());
            } else {
                log.info("Creating and loading native store from " + store.getAbsolutePath());
                store.mkdirs();
            }
        }
        try {
            NativeStore ns = this.createNativeStore(store);
            SailRepository repo = new SailRepository(ns);
            try {
                repo.init();
            }
            finally {
                repo.shutDown();
            }
            ManagedRepositoryEndpoint res = new ManagedRepositoryEndpoint(repoInfo, repoInfo.getLocation(), EndpointClassification.Local, repo);
            res.setEndpointConfiguration(repoInfo.getEndpointConfiguration());
            return res;
        }
        catch (RepositoryException e) {
            throw new FedXException("Repository " + repoInfo.getId() + " could not be initialized: " + e.getMessage(), e);
        }
    }

    protected NativeStore createNativeStore(File store) {
        NativeStore ns = new NativeStore(store);
        SailSourceEvaluationStrategyFactory factory = new SailSourceEvaluationStrategyFactory(ns.getEvaluationStrategyFactory());
        ns.setEvaluationStrategyFactory(factory);
        return ns;
    }
}

