/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIteratorCache;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemStatementIterator
implements CloseableIteration<MemStatement> {
    public static final int MIN_SIZE_TO_CONSIDER_FOR_CACHE = 1000;
    private final int statementListSize;
    private MemStatement[] statementList;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final MemResource[] contexts;
    private final boolean explicit;
    private final boolean explicitNotSpecified;
    private final int snapshot;
    private final boolean noIsolation;
    private int statementIndex;
    private int matchingStatements;
    private MemStatement nextElement;
    private boolean closed = false;
    private final MemStatementIteratorCache iteratorCache;
    private int cachedHashCode = 0;

    public MemStatementIterator(MemStatementList statementList, MemResource subject, MemIRI predicate, MemValue object, Boolean explicit, int snapshot, MemStatementIteratorCache iteratorCache, MemResource ... contexts) throws InterruptedException {
        this.statementList = statementList.getStatements();
        this.statementListSize = statementList.getGuaranteedLastIndexInUse() + 1;
        assert (this.statementListSize <= this.statementList.length);
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.iteratorCache = iteratorCache;
        this.contexts = contexts;
        if (explicit == null) {
            this.explicitNotSpecified = true;
            this.explicit = false;
        } else {
            this.explicitNotSpecified = false;
            this.explicit = explicit;
        }
        this.snapshot = snapshot;
        this.noIsolation = snapshot < 0;
        this.statementIndex = 0;
    }

    public static CloseableIteration<MemStatement> cacheAwareInstance(MemStatementList smallestList, MemResource subj, MemIRI pred, MemValue obj, Boolean explicit, int snapshot, MemResource[] memContexts, MemStatementIteratorCache iteratorCache) throws InterruptedException {
        if (smallestList.size() > 1000) {
            MemStatementIterator memStatementIterator = null;
            try {
                memStatementIterator = new MemStatementIterator(smallestList, subj, pred, obj, explicit, snapshot, iteratorCache, memContexts);
                if (iteratorCache.shouldBeCached(memStatementIterator)) {
                    return iteratorCache.getCachedIterator(memStatementIterator);
                }
                return memStatementIterator;
            }
            catch (Throwable t) {
                if (memStatementIterator != null) {
                    memStatementIterator.close();
                }
                throw t;
            }
        }
        return new MemStatementIterator(smallestList, subj, pred, obj, explicit, snapshot, null, memContexts);
    }

    private MemStatement getNextElement() {
        while (this.statementIndex < this.statementListSize) {
            MemStatement statement;
            if ((statement = this.statementList[this.statementIndex++]) == null || !statement.matchesSPO(this.subject, this.predicate, this.object)) continue;
            if (this.contexts.length > 0) {
                if (!statement.matchesContext(this.contexts) || !this.matchesExplicitAndSnapshot(statement)) continue;
                ++this.matchingStatements;
                return statement;
            }
            if (!this.matchesExplicitAndSnapshot(statement)) continue;
            ++this.matchingStatements;
            return statement;
        }
        return null;
    }

    boolean matchesExplicitAndSnapshot(MemStatement st) {
        return !(!this.explicitNotSpecified && this.explicit != st.isExplicit() || !this.noIsolation && !st.isInSnapshot(this.snapshot));
    }

    private boolean isCandidateForCache() {
        if (this.statementIndex == this.statementListSize && this.statementIndex > 1000) {
            if (this.matchingStatements == 0) {
                return true;
            }
            if (this.matchingStatements < 100) {
                double ratio = ((double)this.statementIndex + 0.0) / (double)this.matchingStatements;
                return ratio > 100.0;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemStatementIterator)) {
            return false;
        }
        MemStatementIterator that = (MemStatementIterator)o;
        return this.explicit == that.explicit && this.explicitNotSpecified == that.explicitNotSpecified && this.snapshot == that.snapshot && this.noIsolation == that.noIsolation && this.subject == that.subject && this.predicate == that.predicate && this.object == that.object && Arrays.equals(this.contexts, that.contexts);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int cachedHashCode = 1;
            cachedHashCode = 31 * cachedHashCode + (this.subject == null ? 0 : this.subject.hashCode());
            cachedHashCode = 31 * cachedHashCode + (this.predicate == null ? 0 : this.predicate.hashCode());
            cachedHashCode = 31 * cachedHashCode + (this.object == null ? 0 : this.object.hashCode());
            cachedHashCode = 31 * cachedHashCode + Boolean.hashCode(this.explicit);
            cachedHashCode = 31 * cachedHashCode + Boolean.hashCode(this.explicitNotSpecified);
            cachedHashCode = 31 * cachedHashCode + this.snapshot;
            cachedHashCode = 31 * cachedHashCode + Boolean.hashCode(this.noIsolation);
            if (this.contexts != null) {
                if (this.contexts.length == 1) {
                    cachedHashCode = this.contexts[0] == null ? (cachedHashCode += 23) : 29 * cachedHashCode + this.contexts[0].hashCode();
                } else if (this.contexts.length > 0) {
                    cachedHashCode = 31 * cachedHashCode + Arrays.hashCode(this.contexts);
                }
            }
            this.cachedHashCode = cachedHashCode;
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return "MemStatementIterator{subject=" + String.valueOf(this.subject) + ", predicate=" + String.valueOf(this.predicate) + ", object=" + String.valueOf(this.object) + ", contexts=" + Arrays.toString(this.contexts) + ", explicit=" + this.explicit + ", explicitNotSpecified=" + this.explicitNotSpecified + ", snapshot=" + this.snapshot + ", noIsolation=" + this.noIsolation + "}";
    }

    public Stats getStats() {
        return new Stats(this.statementIndex, this.matchingStatements);
    }

    @Override
    public final boolean hasNext() {
        if (this.closed) {
            return false;
        }
        return this.lookAhead() != null;
    }

    @Override
    public final MemStatement next() {
        if (this.closed) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        MemStatement result = this.lookAhead();
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private MemStatement lookAhead() {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                this.close();
            }
        }
        return this.nextElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.statementList = null;
            if (this.iteratorCache != null && this.isCandidateForCache()) {
                this.iteratorCache.incrementIteratorFrequencyMap(this);
            }
        }
    }

    static class Stats {
        private final int checkedStatements;
        private final int matchingStatements;

        public Stats(int checkStatements, int matchingStatements) {
            this.checkedStatements = checkStatements;
            this.matchingStatements = matchingStatements;
        }

        public String toString() {
            return "Stats{checkedStatements=" + this.checkedStatements + ", matchingStatements=" + this.matchingStatements + "}";
        }
    }
}

