/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.examples.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.examples.wizards.FormBrowser;
import org.eclipse.jwt.examples.wizards.ImageCanvas;
import org.eclipse.jwt.examples.wizards.JWTExample;
import org.eclipse.jwt.examples.wizards.NewExampleWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class JWTExampleWizardPage
extends WizardPage {
    private FormBrowser browser;
    private Table table;
    private ImageCanvas canvas;

    protected JWTExampleWizardPage(String pageName) {
        super(pageName);
    }

    protected JWTExampleWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.browser = new FormBrowser(2560);
        this.browser.setText("");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        this.table = new Table(container, 4);
        this.table.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                JWTExampleWizardPage.this.handleEvent();
            }
        });
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                JWTExampleWizardPage.this.handleEvent();
            }
        });
        TableItem tableItem = null;
        for (JWTExample jwtExample : ((NewExampleWizard)this.getWizard()).getJWTExamples()) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(jwtExample.getTitle());
        }
        GridData gdTable = new GridData(1296);
        gdTable.heightHint = 100;
        this.table.setLayoutData((Object)gdTable);
        this.browser.createControl(container);
        Control c = this.browser.getControl();
        GridData gd = new GridData(1296);
        gd.heightHint = 100;
        gd.widthHint = 100;
        c.setLayoutData((Object)gd);
        this.canvas = new ImageCanvas(container, 0);
        this.canvas.setImage(null);
        GridData gdImage = new GridData(1296);
        gdImage.heightHint = 100;
        gdImage.widthHint = 400;
        this.canvas.setLayoutData(gdImage);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    int getSelection() {
        return this.table.getSelectionIndex();
    }

    private void handleEvent() {
        if (this.getSelection() > -1) {
            this.browser.setText(((NewExampleWizard)this.getWizard()).getJWTExamples().get(this.table.getSelectionIndex()).getDescription());
            ImageDescriptor imageDescriptor = ((NewExampleWizard)this.getWizard()).getJWTExamples().get(this.table.getSelectionIndex()).getImageDesc();
            Image image = imageDescriptor.createImage();
            this.canvas.setImage(image);
        }
    }
}

