/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.daemon;

public class OpUnitMask {
    public static final int SET_DEFAULT_MASK = -1;
    public static final int INVALID = -1;
    public static final int MANDATORY = 1;
    public static final int EXCLUSIVE = 2;
    public static final int BITMASK = 3;
    private int mask;
    private int defaultMask;
    private int maskType;
    private String[] maskOptionDescriptions = new String[0];
    private int[] maskOptionValues;

    public void setMaskDescriptions(MaskInfo[] masks) {
        this.maskOptionDescriptions = new String[masks.length];
        this.maskOptionValues = new int[masks.length];
        int i = 0;
        while (i < masks.length) {
            this.maskOptionDescriptions[i] = masks[i].description;
            this.maskOptionValues[i] = masks[i].value;
            ++i;
        }
    }

    public void setDefault(int theDefault) {
        this.defaultMask = theDefault;
        this.setDefaultMaskValue();
    }

    public void setType(int type) {
        this.maskType = type;
    }

    public int getMaskValue() {
        return this.mask;
    }

    public boolean isMaskSetFromIndex(int index) {
        boolean result = false;
        if (index >= 0 && index < this.maskOptionValues.length) {
            switch (this.maskType) {
                case 2: {
                    result = this.mask == this.maskOptionValues[index];
                    break;
                }
                case 3: {
                    result = (this.mask & this.maskOptionValues[index]) != 0;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void setMaskValue(int newValue) {
        this.mask = newValue == -1 ? this.defaultMask : newValue;
    }

    public void setMaskFromIndex(int index) {
        if (index >= 0 && index < this.maskOptionValues.length) {
            if (this.maskType == 3) {
                this.mask |= this.maskOptionValues[index];
            } else if (this.maskType == 2) {
                this.mask = this.maskOptionValues[index];
            }
        }
    }

    public int getMaskFromIndex(int index) {
        if (this.maskType == 3) {
            if (index >= 0 && index < this.maskOptionValues.length) {
                return this.maskOptionValues[index];
            }
        } else if (this.maskType == 2) {
            if (index >= 0 && index < this.maskOptionValues.length) {
                return this.maskOptionValues[index];
            }
        } else if (this.maskType == 1) {
            return this.defaultMask;
        }
        return -1;
    }

    public void unSetMaskFromIndex(int index) {
        if (index >= 0 && index < this.maskOptionValues.length && this.maskType == 3) {
            this.mask &= ~this.maskOptionValues[index];
        }
    }

    public void setDefaultMaskValue() {
        this.mask = this.defaultMask;
    }

    public String getText(int num) {
        if (num >= 0 && num < this.maskOptionDescriptions.length) {
            return this.maskOptionDescriptions[num];
        }
        return null;
    }

    public int getNumMasks() {
        return this.maskOptionDescriptions.length;
    }

    public int getType() {
        return this.maskType;
    }

    public static class MaskInfo {
        public int value;
        public String description;
    }
}

