/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core;

import java.util.IdentityHashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.ecommons.text.core.IDocumentEnhancement;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;

public class DocumentEnhancer {
    private static final String POSITION_CATEGORY = "org.eclipse.statet.ecommons.text.DocumentEnhancement";

    private static EnhancementImpl doSetup(IDocument document) throws BadLocationException, BadPositionCategoryException {
        document.addPositionCategory(POSITION_CATEGORY);
        EnhancementImpl documentEnh = new EnhancementImpl();
        document.addPosition(POSITION_CATEGORY, (Position)documentEnh);
        document.addDocumentPartitioningListener((IDocumentPartitioningListener)documentEnh);
        return documentEnh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup(IDocument document) {
        Object object = TextUtils.getLockObject(document);
        synchronized (object) {
            try {
                if (!document.containsPositionCategory(POSITION_CATEGORY)) {
                    DocumentEnhancer.doSetup(document);
                }
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static IDocumentEnhancement get(IDocument document) {
        Object object = TextUtils.getLockObject(document);
        synchronized (object) {
            try {
                if (document.containsPositionCategory(POSITION_CATEGORY)) {
                    return (EnhancementImpl)document.getPositions(POSITION_CATEGORY)[0];
                }
                return DocumentEnhancer.doSetup(document);
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class EnhancementImpl
    extends Position
    implements IDocumentEnhancement,
    IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension2 {
        private final CopyOnWriteIdentityListSet<IDocumentPartitioningListenerExtension2> partitioningListeners = new CopyOnWriteIdentityListSet();
        private IdentityHashMap<String, Object> data;

        private EnhancementImpl() {
        }

        @Override
        public void addPrePartitioningListener(IDocumentPartitioningListenerExtension2 listener) {
            this.partitioningListeners.add((Object)listener);
        }

        @Override
        public void removePrePartitioningListener(IDocumentPartitioningListenerExtension2 listener) {
            this.partitioningListeners.remove((Object)listener);
        }

        public void documentPartitioningChanged(IDocument document) {
        }

        public void documentPartitioningChanged(DocumentPartitioningChangedEvent event) {
            for (IDocumentPartitioningListenerExtension2 listener : this.partitioningListeners) {
                listener.documentPartitioningChanged(event);
            }
        }

        @Override
        public Object getData(String key) {
            return this.data != null ? this.data.get(key) : null;
        }

        @Override
        public void setData(String key, Object value) {
            if (this.data == null) {
                this.data = new IdentityHashMap();
            }
            this.data.put(key, value);
        }
    }
}

