/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.util;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;

public class NonDeletingPositionUpdater
implements IPositionUpdater {
    private final String category;

    public NonDeletingPositionUpdater(String category) {
        if (category == null) {
            throw new NullPointerException("category");
        }
        this.category = category;
    }

    public final String getCategory() {
        return this.category;
    }

    public void update(DocumentEvent event) {
        int eventOffset = event.getOffset();
        int eventLength = event.getLength();
        int eventOldEndOffset = eventOffset + eventLength;
        int eventNewLength = event.getText() == null ? 0 : event.getText().length();
        try {
            Position[] positions = event.getDocument().getPositions(this.category);
            int i = 0;
            while (i != positions.length) {
                Position position = positions[i];
                if (!position.isDeleted()) {
                    int offset = position.getOffset();
                    int endOffset = offset + position.getLength();
                    if (offset > eventOldEndOffset) {
                        position.setOffset(offset + eventNewLength - eventLength);
                    } else if (endOffset >= eventOffset) {
                        if (offset <= eventOffset && endOffset >= eventOldEndOffset) {
                            position.setLength(position.getLength() + eventNewLength - eventLength);
                        } else if (offset < eventOffset) {
                            position.setLength(eventOffset + eventNewLength - offset);
                        } else if (endOffset > eventOldEndOffset) {
                            position.setOffset(eventOffset);
                            position.setLength(endOffset - eventOldEndOffset + eventNewLength);
                        } else {
                            int eventNewEndOffset = eventOffset + eventNewLength;
                            int newOffset = Math.min(offset, eventNewEndOffset);
                            int newEndOffset = Math.min(endOffset, eventNewEndOffset);
                            position.setOffset(newOffset);
                            position.setLength(newEndOffset - newOffset);
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }
}

