/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpaths.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpaths.core.BuildpathElementType;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathElement;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListElement;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListElementAttribute;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListElementComparator;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListLabelProvider;

public class BuildpathsUIDescription {
    public void toListElements(IProject project, List<IBuildpathElement> coreElements, List<BuildpathListElement> listElements) {
        for (IBuildpathElement element : coreElements) {
            listElements.add(new BuildpathListElement(project, null, element, false));
        }
    }

    public ImList<IBuildpathElement> toCoreElements(List<BuildpathListElement> listElements) {
        Object[] coreElements = new IBuildpathElement[listElements.size()];
        int j = 0;
        for (BuildpathListElement listElement : listElements) {
            coreElements[j++] = listElement.getCoreElement();
        }
        return ImCollections.newList((Object[])coreElements);
    }

    public BuildpathListElementComparator createListElementComparator() {
        return new BuildpathListElementComparator();
    }

    public BuildpathListLabelProvider createListLabelProvider() {
        return new BuildpathListLabelProvider();
    }

    public String getDefaultExt(BuildpathListElement element) {
        return "ext";
    }

    public boolean getAllowAdd(IProject project, BuildpathElementType type) {
        return true;
    }

    public boolean getAllowEdit(BuildpathListElement element) {
        return true;
    }

    public boolean getAllowEdit(BuildpathListElementAttribute attribute) {
        return true;
    }
}

