/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.internal.ltk.core.LTKCorePlugin;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.ltk.core.LTKUtils;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.ElementChangedEvent;
import org.eclipse.statet.ltk.model.core.IElementChangedListener;
import org.eclipse.statet.ltk.model.core.IModelElementDelta;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelManager;

public abstract class AbstractModelEventJob<ElementType extends IModelElement, InfoType extends ISourceUnitModelInfo>
extends Job {
    private final AbstractModelManager modelManager;
    private final Object tasksLock = new Object();
    private final LinkedList<IModelElement> taskQueue = new LinkedList();
    private final HashMap<IModelElement, Task> taskDetail = new HashMap();
    private boolean working = false;
    private boolean stop = false;

    public AbstractModelEventJob(AbstractModelManager manager) {
        super("Model Events for " + manager.getModelTypeId());
        this.setPriority(40);
        this.setSystem(true);
        this.setUser(false);
        this.modelManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdate(ElementType element, InfoType oldModel, InfoType newModel) {
        Object object = this.tasksLock;
        synchronized (object) {
            Task task = this.taskDetail.get(element);
            if (task == null) {
                task = new Task(this, element);
                task.oldInfo = oldModel;
                this.taskDetail.put((IModelElement)element, task);
            } else {
                this.taskQueue.remove(element);
            }
            task.newInfo = newModel;
            this.taskQueue.add((IModelElement)element);
            if (!this.working) {
                this.schedule();
            }
        }
    }

    protected abstract IModelElementDelta createDelta(Task var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (true) {
            Task task;
            Object object = this.tasksLock;
            synchronized (object) {
                IModelElement element;
                IModelElement iModelElement = element = !this.taskQueue.isEmpty() ? this.taskQueue.removeFirst() : null;
                if (element == null || this.stop) {
                    this.working = false;
                    return Status.OK_STATUS;
                }
                this.working = true;
                task = this.taskDetail.remove(element);
            }
            try {
                task.run();
                continue;
            }
            catch (Throwable e) {
                LTKCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occurred when firing model event for " + this.modelManager.getModelTypeId() + ".", e));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = this.tasksLock;
        synchronized (object) {
            this.stop = true;
            this.taskQueue.clear();
            this.taskDetail.clear();
        }
    }

    private void fireDelta(IModelElementDelta delta) {
        ISourceUnit su = LTKUtils.getSourceUnit(delta.getModelElement());
        if (su == null) {
            return;
        }
        WorkingContext context = su.getWorkingContext();
        ElementChangedEvent event = new ElementChangedEvent(delta, context);
        SafeRunnable runnable = new SafeRunnable(event);
        ImIdentityList<IElementChangedListener> listeners = this.modelManager.getElementChangedListeners(context);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            IElementChangedListener listener;
            runnable.listener = listener = (IElementChangedListener)iterator.next();
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    private static class SafeRunnable
    implements ISafeRunnable {
        final ElementChangedEvent event;
        IElementChangedListener listener;

        public SafeRunnable(ElementChangedEvent event) {
            this.event = event;
        }

        public void run() {
            this.listener.elementChanged(this.event);
        }

        public void handleException(Throwable e) {
            LTKCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occured while notifying an ElementChangedListener.", e));
        }
    }

    protected static class Task {
        private final ElementType element;
        private InfoType oldInfo;
        private InfoType newInfo;
        final /* synthetic */ AbstractModelEventJob this$0;

        public Task(ElementType element) {
            this.this$0 = var1_1;
            this.element = element;
        }

        public ElementType getElement() {
            return this.element;
        }

        public InfoType getOldInfo() {
            return this.oldInfo;
        }

        public InfoType getNewInfo() {
            return this.newInfo;
        }

        void run() {
            IModelElementDelta delta = this.this$0.createDelta(this);
            this.this$0.fireDelta(delta);
        }
    }
}

