/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.breakpoints;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.internal.r.debug.ui.Messages;
import org.eclipse.statet.internal.r.debug.ui.breakpoints.RLineBreakpointDetailPane;
import org.eclipse.statet.internal.r.debug.ui.breakpoints.RMethodBreakpointDetailPane;
import org.eclipse.statet.r.debug.core.breakpoints.IRBreakpoint;

public class BreakpointDetailFactory
implements IDetailPaneFactory {
    public Set getDetailPaneTypes(IStructuredSelection selection) {
        HashSet<String> types = new HashSet<String>();
        if (selection.size() == 1 && selection.getFirstElement() instanceof IRBreakpoint) {
            String breakpointType = ((IRBreakpoint)selection.getFirstElement()).getBreakpointType();
            if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint") {
                types.add("org.eclipse.statet.r.debugDetailPane.RLineBreakpointDefault");
            } else if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
                types.add("org.eclipse.statet.r.debugDetailPane.RMethodBreakpointDefault");
            }
        }
        return types;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IRBreakpoint) {
            String breakpointType = ((IRBreakpoint)selection.getFirstElement()).getBreakpointType();
            if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint") {
                return "org.eclipse.statet.r.debugDetailPane.RLineBreakpointDefault";
            }
            if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
                return "org.eclipse.statet.r.debugDetailPane.RMethodBreakpointDefault";
            }
        }
        return null;
    }

    public String getDetailPaneName(String paneID) {
        if (paneID.equals("org.eclipse.statet.r.debugDetailPane.RLineBreakpointDefault") || paneID.equals("org.eclipse.statet.r.debugDetailPane.RMethodBreakpointDefault")) {
            return Messages.Breakpoint_DefaultDetailPane_name;
        }
        return null;
    }

    public String getDetailPaneDescription(String paneID) {
        if (paneID.equals("org.eclipse.statet.r.debugDetailPane.RLineBreakpointDefault") || paneID.equals("org.eclipse.statet.r.debugDetailPane.RMethodBreakpointDefault")) {
            return Messages.Breakpoint_DefaultDetailPane_description;
        }
        return null;
    }

    public IDetailPane createDetailPane(String paneID) {
        if (paneID.equals("org.eclipse.statet.r.debugDetailPane.RLineBreakpointDefault")) {
            return new RLineBreakpointDetailPane();
        }
        if (paneID.equals("org.eclipse.statet.r.debugDetailPane.RMethodBreakpointDefault")) {
            return new RMethodBreakpointDetailPane();
        }
        return null;
    }
}

