/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.core.input.DocumentParserInput;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;

public class YamlDefaultTextStyleScanner
extends DocumentParserInput
implements ITokenScanner {
    private static final byte ST_EOF = 0;
    private static final byte ST_DOCUMENT_SEPARATOR = 1;
    private static final byte ST_OTHER_INDICATOR = 2;
    private static final byte ST_BRACKET_INDICATOR = 3;
    private static final byte LAST_OTHER = 0;
    private static final byte LAST_EOF = 1;
    private static final byte LAST_EOL = 2;
    private final TextStyleManager textStyles;
    private final IToken[] tokens;
    private final IToken defaultToken;
    private int currentOffset;
    private int currentLength;
    private byte nextType;
    private int nextLength;
    private byte lastChar;

    public YamlDefaultTextStyleScanner(TextStyleManager textStyles) {
        this.textStyles = textStyles;
        this.defaultToken = this.getToken("yaml_ts_Default");
        this.tokens = new IToken[4];
        this.tokens[0] = Token.EOF;
        this.tokens[1] = this.getToken("yaml_ts_DocumentSeparator");
        this.tokens[2] = this.getToken("yaml_ts_Indicator");
        this.tokens[3] = this.getToken("yaml_ts_Indicator.Bracket");
    }

    protected IToken getToken(String key) {
        return this.textStyles.getToken(key);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.reset(document);
        this.init(offset, offset + length);
        this.currentOffset = offset;
        this.currentLength = 0;
        this.nextLength = -1;
        try {
            if (offset > 0) {
                switch (document.getChar(offset - 1)) {
                    case '\n': 
                    case '\r': {
                        this.lastChar = (byte)2;
                        break;
                    }
                    default: {
                        this.lastChar = 0;
                        break;
                    }
                }
            } else {
                this.lastChar = (byte)2;
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public IToken nextToken() {
        this.currentOffset += this.currentLength;
        this.currentLength = this.nextLength;
        if (this.currentLength >= 0) {
            this.nextLength = -1;
            return this.tokens[this.nextType];
        }
        this.readNext();
        if (this.currentLength > 0) {
            return this.defaultToken;
        }
        this.currentLength = this.nextLength;
        this.nextLength = -1;
        return this.tokens[this.nextType];
    }

    public int getTokenOffset() {
        return this.currentOffset;
    }

    public int getTokenLength() {
        return this.currentLength;
    }

    private void readNext() {
        int offset = 0;
        boolean nl = this.lastChar == 2;
        while (true) {
            int c = this.get(offset);
            switch (c) {
                case -1: {
                    this.newToken(offset, (byte)0, 0);
                    this.lastChar = 1;
                    return;
                }
                case 10: 
                case 13: {
                    nl = true;
                    break;
                }
                case 45: {
                    if (nl && this.matches(1, '-', '-')) {
                        this.newToken(offset, (byte)1, 3);
                        this.lastChar = 0;
                        return;
                    }
                    this.newToken(offset, (byte)2, 1);
                    this.lastChar = 0;
                    return;
                }
                case 58: 
                case 63: {
                    this.newToken(offset, (byte)2, 1);
                    this.lastChar = 0;
                    return;
                }
                case 46: {
                    if (!nl) break;
                    if (this.matches(1, '.', '.')) {
                        int length = 3;
                        while (this.get(length) == 46) {
                            ++length;
                        }
                        this.newToken(offset, (byte)1, length);
                        this.lastChar = 0;
                        return;
                    }
                    nl = false;
                    break;
                }
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    this.newToken(offset, (byte)3, 1);
                    this.lastChar = 0;
                    return;
                }
                default: {
                    nl = false;
                }
            }
            ++offset;
        }
    }

    private void newToken(int offset, byte type, int length) {
        this.currentLength = this.getLengthInSource(offset);
        this.consume(offset);
        this.nextType = type;
        this.nextLength = this.getLengthInSource(length);
        this.consume(length);
    }
}

