/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractFactorStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;
import org.eclipse.statet.rj.data.impl.RUniqueCharacter32Store;

public class RFactor32Store
extends AbstractFactorStore
implements RDataResizeExtension<Integer>,
ExternalizableRStore,
Externalizable {
    private int length;
    protected int[] codes;
    protected RCharacter32Store codeLabels;

    public RFactor32Store(int length, boolean isOrdered, String[] levelLabels) {
        if (levelLabels == null) {
            throw new NullPointerException();
        }
        this.length = length;
        this.isOrdered = isOrdered;
        this.codes = new int[length];
        Arrays.fill(this.codes, Integer.MIN_VALUE);
        this.codeLabels = new RUniqueCharacter32Store(levelLabels);
    }

    public RFactor32Store(int[] codes, boolean isOrdered, String[] levelLabels) {
        if (codes == null || levelLabels == null) {
            throw new NullPointerException();
        }
        this.length = codes.length;
        this.isOrdered = isOrdered;
        this.codes = codes;
        this.codeLabels = new RUniqueCharacter32Store(levelLabels);
    }

    public RFactor32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.isOrdered = io.readBoolean();
        this.codes = io.readIntData(new int[length], length);
        this.codeLabels = this.readLabels(io, io.readInt());
    }

    protected RCharacter32Store readLabels(RJIO io, int l) throws IOException {
        return new RUniqueCharacter32Store(io, l);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeBoolean(this.isOrdered);
        io.writeIntData(this.codes, this.length);
        io.writeInt(this.codeLabels.length());
        this.codeLabels.writeExternal(io);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.isOrdered = in.readBoolean();
        this.length = in.readInt();
        this.codes = new int[this.length];
        int i = 0;
        while (i < this.length) {
            this.codes[i] = in.readInt();
            ++i;
        }
        this.codeLabels = new RUniqueCharacter32Store();
        this.codeLabels.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isOrdered);
        out.writeInt(this.length);
        int i = 0;
        while (i < this.length) {
            out.writeInt(this.codes[i]);
            ++i;
        }
        this.codeLabels.writeExternal(out);
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    protected final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.codes[idx] <= 0;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.codes[(int)idx] <= 0;
    }

    @Override
    public void setNA(int idx) {
        this.codes[idx] = Integer.MIN_VALUE;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.codes[(int)idx] = Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.codes[idx] <= 0;
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.codes[(int)idx] <= 0;
    }

    @Override
    public int getInt(int idx) {
        return this.codes[idx];
    }

    @Override
    public int getInt(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.codes[(int)idx];
    }

    @Override
    public void setInt(int idx, int code) {
        if (code <= 0 || code > this.codeLabels.length()) {
            throw new IllegalArgumentException();
        }
        this.codes[idx] = code;
    }

    @Override
    public void setInt(long idx, int code) {
        if (code <= 0 || code > this.codeLabels.length()) {
            throw new IllegalArgumentException();
        }
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.codes[(int)idx] = code;
    }

    @Override
    public String getChar(int idx) {
        int code = this.codes[idx];
        return code > 0 ? this.codeLabels.getChar(code - 1) : null;
    }

    @Override
    public String getChar(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int code = this.codes[(int)idx];
        return code > 0 ? this.codeLabels.getChar(code - 1) : null;
    }

    @Override
    public void setChar(int idx, String data) {
        int code = this.codeLabels.indexOf(data, 0) + 1;
        if (code <= 0) {
            throw new IllegalArgumentException();
        }
        this.codes[idx] = code;
    }

    @Override
    public void setChar(long idx, String data) {
        int code = this.codeLabels.indexOf(data, 0) + 1;
        if (code <= 0) {
            throw new IllegalArgumentException();
        }
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.codes[(int)idx] = code;
    }

    private void prepareInsert(int[] idxs) {
        this.codes = RFactor32Store.prepareInsert(this.codes, this.length, idxs);
        this.length += idxs.length;
    }

    public void insertChar(int idx, String data) {
        int code = this.codeLabels.indexOf(data, 0) + 1;
        if (code <= 0) {
            throw new IllegalArgumentException();
        }
        this.prepareInsert(new int[]{idx});
        this.codes[idx] = code;
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.codes[idx] = Integer.MIN_VALUE;
    }

    @Override
    public void insertNA(int[] idxs) {
        this.prepareInsert(idxs);
        int idx = 0;
        while (idx < idxs.length) {
            this.codes[idx] = Integer.MIN_VALUE;
            ++idx;
        }
    }

    @Override
    public void remove(int idx) {
        this.codes = RFactor32Store.remove(this.codes, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.codes = RFactor32Store.remove(this.codes, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public RCharacterStore getLevels() {
        return this.codeLabels;
    }

    @Override
    public int getLevelCount() {
        return this.codeLabels.length();
    }

    public void addLevel(String label) {
        this.insertLevel(this.codes.length, label);
    }

    public void insertLevel(int position, String label) {
        this.codeLabels.insertChar(position, label);
        if ((long)position < this.codeLabels.getLength() - 1L) {
            int length = this.length();
            int i = 0;
            while (i < length) {
                if (this.codes[i] >= position) {
                    int n = i;
                    this.codes[n] = this.codes[n] + 1;
                }
                ++i;
            }
        }
    }

    public void renameLevel(String oldLabel, String newLabel) {
        int code = this.codeLabels.indexOf(oldLabel, 0) + 1;
        if (code <= 0) {
            throw new IllegalArgumentException();
        }
        this.codeLabels.setChar(code - 1, newLabel);
    }

    public void removeLevel(String label) {
        int code = this.codeLabels.indexOf(label, 0) + 1;
        if (code <= 0) {
            throw new IllegalArgumentException();
        }
        this.codeLabels.remove(code - 1);
        int length = this.length();
        int i = 0;
        while (i < length) {
            if (this.codes[i] == code) {
                this.codes[i] = Integer.MIN_VALUE;
            } else if (this.codes[i] > code) {
                int n = i;
                this.codes[n] = this.codes[n] - 1;
            }
            ++i;
        }
    }

    @Override
    public RCharacterStore toCharacterData() {
        String[] data = new String[this.length()];
        int[] ints = this.codes;
        int i = 0;
        while (i < data.length) {
            int code = ints[i];
            if (code > 0) {
                data[i] = this.codeLabels.getChar(this.codes[i] - 1);
            }
            ++i;
        }
        return new RCharacter32Store(data);
    }

    @Override
    public Integer get(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int code = this.codes[idx];
        return code > 0 ? Integer.valueOf(code) : null;
    }

    @Override
    public Integer get(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int code = this.codes[(int)idx];
        return code > 0 ? Integer.valueOf(code) : null;
    }

    @Override
    public Integer[] toArray() {
        Integer[] array = new Integer[this.length()];
        int[] ints = this.codes;
        int i = 0;
        while (i < array.length) {
            int code = ints[i];
            if (code > 0) {
                array[i] = code;
            }
            ++i;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length();
        int[] ints = this.codes;
        int i = (int)fromIdx;
        while (i < l) {
            if (ints[i] == Integer.MIN_VALUE) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long indexOf(int code, long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE || code <= 0 || code > this.codeLabels.length()) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length();
        int[] ints = this.codes;
        int i = (int)fromIdx;
        while (i < l) {
            if (ints[i] == code) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        int code = (character != null ? this.codeLabels.indexOf(character, 0) : this.codeLabels.indexOfNA(0)) + 1;
        return this.indexOf(code, fromIdx);
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

