/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.resources.core.variables;

import java.io.File;
import java.net.URI;
import java.util.Locale;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ecommons.debug.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ResourceVariableResolver
implements IDynamicVariableResolver {
    private static final byte EXISTS_MASK = 12;
    public static final byte EXISTS_NEVER = 0;
    public static final byte EXISTS_SELECTED = 4;
    public static final byte EXISTS_ALWAYS = 8;
    protected static final byte RESOURCE = 1;
    protected static final byte CONTAINER = 2;
    protected static final byte PROJECT = 3;
    private static final Context DEFAULT_CONTEXT = new SelectedResourceContext();
    private final Context context;
    private final byte flags;

    public ResourceVariableResolver() {
        this(null, 4);
    }

    public ResourceVariableResolver(Context context) {
        this(context, 4);
    }

    public ResourceVariableResolver(@Nullable Context context, byte flags) {
        this.context = context != null ? context : DEFAULT_CONTEXT;
        this.flags = flags;
    }

    protected Context getContext() {
        return this.context;
    }

    public @Nullable String resolveValue(IDynamicVariable variable, @Nullable String argument) throws CoreException {
        switch (variable.getName()) {
            case "resource_loc": {
                return this.toLocValue(variable, this.getResource(variable, (byte)1, argument));
            }
            case "resource_path": {
                return this.toPathValue(variable, this.getResource(variable, (byte)1, argument));
            }
            case "resource_name": {
                return this.toNameValue(variable, this.getResource(variable, (byte)1, argument));
            }
            case "resource_enc": {
                return this.toEncValue(variable, this.getResource(variable, (byte)1, argument));
            }
            case "container_loc": {
                return this.toLocValue(variable, this.getResource(variable, (byte)2, argument));
            }
            case "container_path": {
                return this.toPathValue(variable, this.getResource(variable, (byte)2, argument));
            }
            case "container_name": {
                return this.toNameValue(variable, this.getResource(variable, (byte)2, argument));
            }
            case "container_enc": {
                return this.toEncValue(variable, this.getResource(variable, (byte)2, argument));
            }
            case "project_loc": {
                return this.toLocValue(variable, this.getResource(variable, (byte)3, argument));
            }
            case "project_path": {
                return this.toPathValue(variable, this.getResource(variable, (byte)3, argument));
            }
            case "project_name": {
                return this.toNameValue(variable, this.getResource(variable, (byte)3, argument));
            }
            case "project_enc": {
                return this.toEncValue(variable, this.getResource(variable, (byte)3, argument));
            }
            case "file_name_base": {
                return this.toNameBaseValue(variable, this.getResourcePath(variable, argument));
            }
            case "file_name_ext": {
                return this.toNameExtValue(variable, this.getResourcePath(variable, argument));
            }
        }
        throw new UnsupportedOperationException(variable.getName());
    }

    protected boolean requireExists(IDynamicVariable variable, @Nullable String argument) {
        switch (this.flags & 0xC) {
            case 0: {
                return false;
            }
            case 4: {
                return argument == null;
            }
            case 8: {
                return true;
            }
        }
        throw new IllegalStateException("flags= " + Integer.toBinaryString(this.flags));
    }

    protected IResource getResource(IDynamicVariable variable, byte resourceType, @Nullable String argument) throws CoreException {
        IResource resource;
        if (argument == null) {
            resource = this.context.getResource();
            if (resource == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", NLS.bind((String)Messages.ResourceVariable_error_Resource_EmptySelection_message, (Object)variable.getName())));
            }
        } else {
            Path path;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (!root.getFullPath().isValidPath(argument) || (path = new Path(argument)).isEmpty() || path.getDevice() != null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", NLS.bind((String)Messages.ResourceVariable_error_Resource_InvalidPath_message, (Object)variable.getName(), (Object)argument)));
            }
            resource = root.findMember((IPath)path);
            if (resource == null && !this.requireExists(variable, argument) && path.segmentCount() > 1) {
                resource = root.getFile((IPath)path);
            }
        }
        if (resource != null) {
            resource = this.toVariableResource(variable, resourceType, resource);
        }
        if (resource == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", NLS.bind((String)Messages.ResourceVariable_error_Resource_NonExisting_message, (Object)variable.getName(), (Object)argument)));
        }
        if (this.requireExists(variable, argument) && !resource.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", NLS.bind((String)Messages.ResourceVariable_error_Resource_NonExisting_message, (Object)variable.getName(), (Object)resource.getFullPath().toString())));
        }
        return resource;
    }

    protected IPath getResourcePath(IDynamicVariable variable, @Nullable String argument) throws CoreException {
        if (argument == null) {
            return this.getResource(variable, (byte)1, argument).getFullPath();
        }
        return new Path(argument);
    }

    protected IResource toVariableResource(IDynamicVariable variable, byte resourceType, IResource resource) {
        switch (resourceType) {
            case 1: {
                return resource;
            }
            case 2: {
                return resource.getParent();
            }
            case 3: {
                return resource.getProject();
            }
        }
        throw new UnsupportedOperationException(variable.getName());
    }

    protected String toLocValue(IDynamicVariable variable, IResource resource) throws CoreException {
        File file;
        URI uri = resource.getLocationURI();
        if (uri != null && (file = EFS.getStore((URI)uri).toLocalFile(0, null)) != null) {
            return file.getAbsolutePath();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", NLS.bind((String)Messages.ResourceVariable_error_Resource_InvalidPath_message, (Object)variable.getName(), (Object)resource.getFullPath().toString())));
    }

    protected String toPathValue(IDynamicVariable variable, IResource resource) throws CoreException {
        return resource.getFullPath().toString();
    }

    protected String toNameValue(IDynamicVariable variable, IResource resource) throws CoreException {
        return resource.getName();
    }

    protected @Nullable String toEncValue(IDynamicVariable variable, IResource resource) throws CoreException {
        String charset = resource instanceof IFile ? ((IFile)resource).getCharset(true) : ((IContainer)resource).getDefaultCharset(true);
        if (charset != null && charset.startsWith("utf")) {
            charset = charset.toUpperCase(Locale.ROOT);
        }
        return charset;
    }

    protected @Nullable String toNameBaseValue(IDynamicVariable variable, IPath path) {
        String lastSegment = path.lastSegment();
        if (lastSegment == null) {
            return null;
        }
        String extension = path.getFileExtension();
        return extension != null ? lastSegment.substring(0, lastSegment.length() - (extension.length() + 1)) : lastSegment;
    }

    protected @Nullable String toNameExtValue(IDynamicVariable variable, IPath path) {
        return path.getFileExtension();
    }

    public static interface Context {
        public @Nullable IResource getResource();
    }

    public static class SelectedResourceContext
    implements Context {
        @Override
        public @Nullable IResource getResource() {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                String path = manager.performStringSubstitution("${selected_resource_path}");
                return ResourcesPlugin.getWorkspace().getRoot().findMember(path, true);
            }
            catch (CoreException e) {
                return null;
            }
        }
    }
}

