/*********************************************************************
 * Copyright (c) 2019 Kichwa Coders and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { GDBDebugSession } from './GDBDebugSession';
import { DebugProtocol } from '@vscode/debugprotocol';
import { TargetLaunchRequestArguments, TargetAttachRequestArguments } from '../types/session';
import { IGDBBackendFactory, IGDBServerFactory, IGDBServerProcessManager, IStdioProcess } from '../types/gdb';
export declare class GDBTargetDebugSession extends GDBDebugSession {
    protected gdbserver?: IStdioProcess;
    protected gdbserverFactory?: IGDBServerFactory;
    protected gdbserverProcessManager?: IGDBServerProcessManager;
    protected killGdbServer: boolean;
    /**
     * Define the target type here such that we can run the "disconnect"
     * command when servicing the disconnect request if the target type
     * is remote.
     */
    protected targetType?: string;
    constructor(backendFactory?: IGDBBackendFactory, gdbserverFactory?: IGDBServerFactory);
    protected setupCommonLoggerAndBackends(args: TargetLaunchRequestArguments | TargetAttachRequestArguments): Promise<void>;
    protected attachOrLaunchRequest(response: DebugProtocol.Response, request: 'launch' | 'attach', args: TargetLaunchRequestArguments | TargetAttachRequestArguments): Promise<void>;
    protected launchRequest(response: DebugProtocol.LaunchResponse, args: TargetLaunchRequestArguments): Promise<void>;
    protected attachRequest(response: DebugProtocol.AttachResponse, args: TargetAttachRequestArguments): Promise<void>;
    protected startGDBServer(args: TargetLaunchRequestArguments): Promise<void>;
    protected startGDBAndAttachToTarget(response: DebugProtocol.AttachResponse | DebugProtocol.LaunchResponse, args: TargetAttachRequestArguments): Promise<void>;
    protected stopGDBServer(): Promise<void>;
    /**
     * WARNING: `disconnectRequest` is unreliable in sync mode.
     * @see {@link https://github.com/eclipse-cdt-cloud/cdt-gdb-adapter/pull/339#discussion_r1840549671}
     */
    protected disconnectRequest(response: DebugProtocol.DisconnectResponse, _args: DebugProtocol.DisconnectArguments): Promise<void>;
}
