/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.SaveEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SaveEntityFeatureTest {
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        Thread.sleep(2000L);
    }

    @Test
    public void testExecute() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        int cnt = 0;
        while (cnt < 25 && t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
            ++cnt;
        }
        if (t1 == null) {
            return;
        }
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement(pe)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit((PersistentType)EasyMock.isA(PersistentType.class))).andReturn((Object)this.createCompilationUnitFrom(customerFile)).anyTimes();
        SaveEntityFeature ft = new SaveEntityFeature((IFeatureProvider)featureProvider);
        ICustomContext ctx = (ICustomContext)EasyMock.createMock(ICustomContext.class);
        PictogramElement[] pes = new PictogramElement[]{pe};
        EasyMock.expect((Object)ctx.getPictogramElements()).andStubReturn((Object)pes);
        EasyMock.replay((Object[])new Object[]{featureProvider, ctx, pe});
        ft.execute(ctx);
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }
}

