/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.defaults;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.IPropertyDefaults;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.defaults.ParameterPropertyDefaultsAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.defaults.PropertyDefaultsAdapterFactory;

public class ParameterPropertyDefaultsAdapterTest
extends TestCase {
    private IWebMethod webMethod;
    private IWebParam webParam;
    private IPropertyDefaults defaults;

    public void setUp() {
        this.webMethod = DomFactory.eINSTANCE.createIWebMethod();
        this.webMethod.setSoapBindingStyle(SOAPBindingStyle.DOCUMENT);
        this.webMethod.setSoapBindingUse(SOAPBindingUse.LITERAL);
        this.webMethod.setSoapBindingParameterStyle(SOAPBindingParameterStyle.WRAPPED);
        this.webParam = DomFactory.eINSTANCE.createIWebParam();
        this.webParam.eSet((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION, (Object)"myParam");
        IWebParam dummy = DomFactory.eINSTANCE.createIWebParam();
        dummy.eSet((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION, (Object)"dummy");
        this.webMethod.getParameters().add((Object)dummy);
        this.webMethod.getParameters().add((Object)this.webParam);
        this.defaults = (IPropertyDefaults)PropertyDefaultsAdapterFactory.INSTANCE.adapt((Notifier)this.webParam, IPropertyDefaults.class);
    }

    public void testNameDefaultValue() {
        this.webParam.setName("test");
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)"arg1", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
    }

    public void testPartNameDefaultValue() {
        this.webParam.setPartName("test");
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)"arg1", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
    }

    public void testPartNameMethodParamStyleBare() {
        this.webMethod.setSoapBindingParameterStyle(SOAPBindingParameterStyle.BARE);
        this.webMethod.setName("test");
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)"test", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
    }

    public void testTargetNSDefaultValue() {
        this.webParam.setTargetNamespace("test");
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)"", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
    }

    public void testTargetNSParamInHeaderDefaultValue() {
        IServiceEndpointInterface sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        sei.setTargetNamespace("http://test");
        sei.getWebMethods().add((Object)this.webMethod);
        this.webParam.setHeader(true);
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)"http://test", (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
    }

    public void testHeaderDefaultValue() {
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)false, (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__HEADER));
    }

    public void testKindDefaultValue() {
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)WebParamKind.IN, (Object)this.defaults.getDefault((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__KIND));
    }

    public void testAdaptedOnce() {
        IPropertyDefaults adapter = (IPropertyDefaults)PropertyDefaultsAdapterFactory.INSTANCE.adapt((Notifier)this.webParam, IPropertyDefaults.class);
        ParameterPropertyDefaultsAdapterTest.assertTrue((boolean)(adapter instanceof ParameterPropertyDefaultsAdapter));
        ParameterPropertyDefaultsAdapterTest.assertEquals((int)1, (int)this.webParam.eAdapters().size());
        ParameterPropertyDefaultsAdapterTest.assertEquals((Object)this.defaults, (Object)adapter);
    }
}

