/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleResourceStringStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * blancoResourceBundle XMLt@C`p[X(ǂݏ)NXB
 * 
 * : 2007.09.19_ł́AvpeBt@Ĉ݂ ̃NX𗘗pĂ܂B
 * Õv_Ng\[Xoh̒ԃt@CɃANZXۂɂÃNX𗘗p邱Ƃz肵Ă܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXmlParser {
    /**
     * XMLt@CXMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoResourceBundleBundleStructure[] parse(
            final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoResourceBundleBundleStructure[] parse(
            final BlancoXmlDocument argXmlDocument) {
        final ArrayList listStructure = new ArrayList();

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");

        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                    elementSheet, "blancoresourcebundle-common");
            if (listCommon.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            final BlancoResourceBundleBundleStructure objResourceBaseStructure = parseElementSheet(elementSheet);
            if (objResourceBaseStructure != null) {
                // ꂽL܂B
                listStructure.add(objResourceBaseStructure);
            }
        }

        final BlancoResourceBundleBundleStructure[] result = new BlancoResourceBundleBundleStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoResourceBundleBundleStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoResourceBundleBundleStructure resourceBaseStructure = new BlancoResourceBundleBundleStructure();
        final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancoresourcebundle-common");
        if (listCommon == null || listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                .get(0);
        resourceBaseStructure.setName(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "baseName"));

        // JgP[L܂B
        resourceBaseStructure.setCurrentLocale(BlancoXmlBindingUtil
                .getTextContent(elementCommon, "locale"));

        final List localeList = BlancoXmlBindingUtil.getElementsByTagName(
                elementCommon, "locale");
        for (int indexLocale = 0; indexLocale < localeList.size(); indexLocale++) {
            final BlancoXmlElement elementLocale = (BlancoXmlElement) localeList
                    .get(indexLocale);
            // Combine̒XMLł́Alocale͕oꂵ܂B
            resourceBaseStructure.getListLocale().add(
                    BlancoXmlBindingUtil.getTextContent(elementLocale));
        }

        resourceBaseStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "packageName"));
        resourceBaseStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "suffix"));
        resourceBaseStructure.setDescription(BlancoXmlBindingUtil
                .getTextContent(elementCommon, "description"));

        if (BlancoStringUtil.null2Blank(resourceBaseStructure.getName()).trim()
                .length() == 0) {
            return null;
        }
        if (BlancoStringUtil.null2Blank(resourceBaseStructure.getPackage())
                .trim().length() == 0) {
            return null;
        }
        if (resourceBaseStructure.getListLocale().size() == 0) {
            return null;
        }

        final List listList = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancoresourcebundle-resourceList");
        final BlancoXmlElement elementListRoot = (BlancoXmlElement) listList
                .get(0);
        final List listChildNodes = BlancoXmlBindingUtil.getElementsByTagName(
                elementListRoot, "resource");
        for (int index = 0; index < listChildNodes.size(); index++) {
            if (listChildNodes.get(index) instanceof BlancoXmlElement == false) {
                continue;
            }
            final BlancoXmlElement elementList = (BlancoXmlElement) listChildNodes
                    .get(index);
            final BlancoResourceBundleBundleItemStructure resourceItemStructure = new BlancoResourceBundleBundleItemStructure();

            resourceItemStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementList, "no"));
            resourceItemStructure.setKey(BlancoXmlBindingUtil.getTextContent(
                    elementList, "resourceKey"));

            final List listResourceString = BlancoXmlBindingUtil
                    .getElementsByTagName(elementList, "resourceString");
            for (int indexString = 0; indexString < listResourceString.size(); indexString++) {
                final BlancoXmlElement eleResourceString = (BlancoXmlElement) listResourceString
                        .get(indexString);
                final BlancoResourceBundleBundleResourceStringStructure resourceMessageItem = new BlancoResourceBundleBundleResourceStringStructure();
                resourceMessageItem.setLocale(BlancoXmlBindingUtil
                        .getAttribute(eleResourceString, "locale"));
                resourceMessageItem.setResourceString(BlancoXmlBindingUtil
                        .getTextContent(eleResourceString));

                resourceItemStructure.getResourceStringList().add(
                        resourceMessageItem);
            }

            // ResourceKey nullłĂǉ܂B
            // ̓Rg\̂łB

            resourceBaseStructure.getItemList().add(resourceItemStructure);
        }

        return resourceBaseStructure;
    }
}
