/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.batchprocess.BlancoBatchProcessConstants;
import blanco.batchprocess.BlancoBatchProcessMeta2Xml;
import blanco.batchprocess.BlancoBatchProcessXml2SourceFile;
import blanco.batchprocess.resourcebundle.BlancoBatchProcessMessageResourceBundle;
import blanco.batchprocess.task.valueobject.BlancoBatchProcessBatchProcessInput;

/**
 * ob`NX
 * 
 * ob`̌ĂяoB
 * 
 * <code>
 * java -classpath (NXpX) blanco.batchprocess.task.BlancoBatchProcessBatchProcess -help
 * </code>
 */
public class BlancoBatchProcessBatchProcess extends
        AbstractBlancoBatchProcessBatchProcess {
    /**
     * bZ[WNXB
     */
    protected final BlancoBatchProcessMessageResourceBundle fMsg = new BlancoBatchProcessMessageResourceBundle();

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     * 
     * ̃\bhɎۂ̏eLq܂B
     * 
     * @param input
     *            ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION,
     *         END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException
     *             o͗OꍇB
     */
    public int process(final BlancoBatchProcessBatchProcessInput input)
            throws IOException {
        System.out.println("- " + BlancoBatchProcessConstants.PRODUCT_NAME
                + " (" + BlancoBatchProcessConstants.VERSION + ")");

        // ̓p[^`FbN܂B
        validateInput(input);

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbbpa001(input
                        .getMetadir()));
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoBatchProcessConstants.TARGET_SUBDIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoBatchProcessMeta2Xml().processDirectory(fileMetadir,
                    input.getTmpdir()
                            + BlancoBatchProcessConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoBatchProcessConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoBatchProcessXml2SourceFile().process(
                        fileMeta2[index], input.getRuntimepackage(), input
                                .getTargetlang(),
                        new File(input.getTargetdir()));
            }

            return END_SUCCESS;
        } catch (TransformerException ex) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + ex.toString());
        }
    }
}
