/*
 * Copyright (C) 2018 The Android Open Source Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

// Reduced trace based on 2.4 billion samples extracted from specpu2017
// 521.wrf_r benchmark.
static const std::vector<float> expf_input = {
  -0x0p+0,
  -0x1.092bd4p+2,
  -0x1.8af5ecp-1,
  0x1.45659p+3,
  0x1.388742p+3,
  0x1.3857eep+3,
  -0x1.80f2ep+0,
  -0x1.3a3adcp+1,
  -0x1.07b87ap+0,
  0x1.3c5c22p+3,
  0x1.ede768p+2,
  -0x1.bb5bcp-2,
  -0x1.0e7d6ep+5,
  -0x1.79ac4p+4,
  0x1.20fe8ap+3,
  -0x1.616dd4p+3,
  -0x1.7d3bc2p+0,
  0x1.0b8384p+0,
  0x1.44422ap+3,
  0x1.e3bce8p+2,
  0x1.44d11ap+3,
  0x1.cfdd92p+2,
  -0x1.b5093p+1,
  0x1.9d1724p+1,
  0x1.9471bcp+2,
  0x1.9ccc52p+0,
  -0x1.e1ea14p+0,
  -0x1.46d1ecp-3,
  0x1.927332p-2,
  -0x1.d553a2p+1,
  0x1.923732p+0,
  0x1.6aea06p+2,
  0x1.92eb6cp-1,
  -0x1.a7cd8ep+2,
  -0x1.bda41p+2,
  -0x1.312bb8p+1,
  0x1.b52ab2p+1,
  -0x1.a90d4ep+2,
  -0x1.26bc92p+2,
  -0x1.6035eep-3,
  -0x1.7dbc7ep+3,
  -0x1.736a64p-1,
  -0x1.7595c8p+2,
  -0x1.dade16p-1,
  0x1.b3d2c8p+2,
  -0x1.ec98dep+1,
  -0x1.134a88p+0,
  0x1.c5fafap+1,
  0x1.255ee4p-3,
  -0x1.2da37ep+6,
  -0x1.7e171ep+0,
  0x1.d9f48ap+2,
  -0x1.75f3eep+2,
  0x1.3e8f9ap+3,
  -0x1.608296p-3,
  0x1.b5f2dcp+2,
  0x1.d86428p+0,
  0x1.412beap+3,
  -0x1.3ea40ap+1,
  -0x1.41dfc4p+2,
  -0x1.21bd5p-2,
  -0x1.54fdf8p+2,
  -0x1.608d6ap-3,
  -0x1.863facp+2,
  0x1.ae490ap+2,
  -0x1.b04428p+0,
  0x1.e5a47p+1,
  0x1.bcf1aep+0,
  0x1.3c662ap+0,
  -0x1.3b0756p+0,
  -0x1.6bafb2p+2,
  0x1.7bc0dcp+2,
  0x1.444f44p+3,
  0x1.44609ap+3,
  0x1.165ffep+0,
  0x1.d47be6p+2,
  -0x1.4263ecp+1,
  -0x1.8e061ep+2,
  0x1.0f0eb8p+0,
  -0x1.3fd988p+2,
  0x1.4f49f6p+1,
  -0x1.543c3cp+3,
  -0x1.5f0aa4p-3,
  -0x1.5c3fa2p+2,
  -0x1.82b9b2p+2,
  -0x1.64ce3ap-3,
  0x1.79f9f8p+2,
  0x1.b24b12p+2,
  -0x1.43658cp+3,
  -0x1.658068p+0,
  0x1.203d1cp+0,
  -0x1.c142c6p-1,
  0x1.9a1cd6p+1,
  -0x1.ade766p+1,
  0x1.daf22p+2,
  -0x1.62f814p-1,
  -0x1.79bb9cp+0,
  -0x1.38a3e4p+0,
  -0x1.dea0fp+2,
  -0x1.f09064p+1,
  0x1.e8baep-1,
  -0x1.deb80cp+0,
  0x1.bc846ap+2,
  0x1.ebc59ep+2,
  -0x1.4e3848p+3,
  0x1.d42b04p+2,
  0x1.e0cb2ep-3,
  -0x1.7ee3d6p-2,
  0x1.dfc3a4p+2,
  -0x1.7b7d56p+2,
  -0x1.59d8b6p+2,
  -0x1.17cea4p+0,
  -0x1.a9839ep+2,
  0x1.e985b6p+2,
  -0x1.eb72dp+2,
  0x1.0dd7aep-1,
  -0x1.0325eap+1,
  0x1.a7f02ep+1,
  -0x1.fab7e2p+1,
  0x1.ab8e12p+2,
  0x1.a28b4ep+2,
  0x1.136d86p-4,
  -0x1.eafep+0,
  -0x1.a5b8ep+4,
  -0x1.217af6p+0,
  -0x1.517d18p-1,
  -0x1.525346p+2,
  0x1.4b30ccp-1,
  -0x1.5ea04ep-3,
  -0x1.b96c1p+2,
  -0x1.23c61ep+1,
  0x1.1e53dcp-2,
  -0x1.f550e2p-2,
  0x1.9d8e66p+0,
  0x1.c1578cp+2,
  0x1.c4bbfcp+2,
  -0x1.5a1902p+2,
  0x1.d8469cp+2,
  0x1.43d612p+3,
  -0x1.578826p+1,
  -0x1.0ff7e6p+3,
  -0x1.f89a3cp-3,
  0x1.71853ap+2,
  0x1.a8240cp+2,
  -0x1.40a39ap+0,
  -0x1.2130e4p+2,
  0x1.3abdbep+0,
  0x1.9b57d6p+0,
  -0x1.21eed8p+3,
  -0x1.593d7cp-1,
  0x1.a0b0d4p+2,
  0x1.1f2aa4p+0,
  0x1.e06742p+1,
  0x1.bab072p+2,
  0x1.46825ep+1,
  -0x1.6c8604p+2,
  0x1.980152p+2,
  -0x1.76b6eep-1,
  0x1.3d30c2p+3,
  0x1.996adap+2,
  0x1.3b8866p+3,
  -0x1.7b4842p-2,
  -0x1.1df6b8p-1,
  -0x1.daa564p+2,
  0x1.cc7028p+1,
  0x1.71de86p+0,
  -0x1.6c3d08p+0,
  0x1.91c468p-1,
  -0x1.3ba51ep-3,
  -0x1.135962p-4,
  -0x1.1f891p+2,
  0x1.aa1e92p+2,
  0x1.ccb4eap+2,
  0x1.cca312p+2,
  -0x1.bbb332p-3,
  -0x1.e86bc8p+1,
  0x1.53c07ap-1,
  0x1.35d8cp+3,
  0x1.47f866p+0,
  0x1.9808a4p-1,
  -0x1.fbf91cp+2,
  -0x1.956b98p+1,
  -0x1.8c3e7ap+2,
  -0x1.a907e2p+2,
  -0x1.792b7p+1,
  -0x1.5c0e9p-7,
  0x1.4629ecp-1,
  0x1.30fed6p+1,
  -0x1.aa670ap+4,
  -0x1.65a70ap-2,
  0x1.668866p+0,
  0x1.572f5cp-2,
  -0x1.55aa82p+2,
  -0x1.1336c2p+1,
  0x1.3a2c32p+2,
  0x1.17d2b8p-1,
  0x1.c1f8bcp+1,
  0x1.10cb0ep+3,
  -0x1.b28c42p+1,
  -0x1.adc0fcp-1,
  -0x1.7260c4p+2,
  -0x1.5e4ae4p-2,
  0x1.a4763ap+2,
  -0x1.314ab2p-3,
  -0x1.81ef1cp+2,
  -0x1.a36d9ep+2,
  -0x1.d85266p-1,
  -0x1.503506p+5,
  0x1.45401ep+3,
  -0x1.0b5af6p+0,
  -0x1.bfd03ap+2,
  0x1.487766p+3,
  -0x1.490c08p+4,
  0x1.5f2852p-3,
  -0x1.0e805cp+0,
  -0x1.4d25aap+5,
  -0x1.14973ep+2,
  -0x1.a416b2p-1,
  0x1.0e2bccp+1,
  0x1.213eb8p-4,
  0x1.3fabaep+0,
  0x1.ebf592p-1,
  -0x1.58f156p+2,
  -0x1.e47384p-1,
  0x1.41a968p+3,
  -0x1.62169ap+1,
  -0x1.24518ap+0,
  -0x1.2b3848p+2,
  -0x1.2473e2p+2,
  0x1.cbf3f6p+2,
  0x1.c7647ap-1,
  0x1.0d0038p-1,
  0x1.35fc7ep+3,
  0x1.3f8aa6p+3,
  -0x1.647b64p-3,
  -0x1.5bbab6p-3,
  -0x1.79c962p+2,
  -0x1.57007ap-3,
  -0x1.06533ap+2,
  -0x1.43c814p+0,
  0x1.8b8652p+0,
  0x1.872cb8p+0,
  -0x1.7b02ap-3,
  -0x1.111332p-2,
  -0x1.5cfe1ep-3,
  -0x1.5da536p-3,
  0x1.10caacp+3,
  0x1.ae6508p+2,
  0x1.3bef7ap+3,
  0x1.282ec8p+2,
  -0x1.9a2e56p+2,
  -0x1.5bf556p-3,
  -0x1.010ea8p+3,
  0x1.7b5c7ap-2,
  -0x1.648d0ap+0,
  -0x1.4f6a82p+0,
  0x1.432dcep+3,
  0x1.78819ep+2,
  -0x1.417cfap+2,
  -0x1.9c93eap+2,
  -0x1.477822p+2,
  -0x1.5f354ep-3,
  0x1.3752eep+2,
  -0x1.d8cd0ap+2,
  -0x1.08e0a4p+0,
  0x1.87b0b8p+0,
  -0x1.32451ep+1,
  0x1.305e7p+0,
  -0x1.649322p-3,
  -0x1.a2bp-2,
  -0x1.60850cp-3,
  -0x1.60f59ap-3,
  0x1.79ce2cp-1,
  -0x1.647d6ap-3,
  0x1.a828ep+0,
  -0x1.7cd6ep+0,
  0x1.44835ep+3,
  0x1.0bd40cp+0,
  -0x1.b370ccp+0,
  -0x1.b13c84p+2,
  0x1.82c1dp-1,
  -0x1.529398p+5,
  -0x1.1a187ep-3,
  0x1.d57a16p+2,
  0x1.30bf36p+2,
  -0x1.449d04p+3,
  -0x1.569fcep-3,
  -0x1.185e66p+4,
  0x1.e631eap-2,
  -0x1.ac70f6p-1,
  0x1.4627e8p+3,
  -0x1.633cc4p-3,
  0x1.9f868ep+2,
  -0x1.db78ep-1,
  -0x1.6b700ap+2,
  -0x1.04137ep+1,
  0x1.6b8552p+0,
  0x1.37ad6p+3,
  0x1.75f16p+3,
  -0x1.811434p+1,
  0x1.417fcep+3,
  -0x1.f1ce28p-2,
  0x1.363584p+3,
  0x1.ff1094p+1,
  0x1.90a454p+2,
  -0x1.cb3544p+1,
  -0x1.651e0ep-3,
  0x1.80cdf4p+3,
  0x1.5fcd1ap+0,
  -0x1.31335cp+5,
  0x1.aa75dep+2,
  0x1.db9a66p+0,
  -0x1.52754p+3,
  0x1.10a55ep+0,
  0x1.cae0eap+2,
  0x1.c6af44p-1,
  -0x1.cde492p+1,
  -0x1.93aab4p+1,
  -0x1.1213c4p+2,
  -0x1.9c4b32p+0,
  -0x1.d8fa66p+0,
  0x1.5cf4a6p+2,
  -0x1.90565ap+2,
  0x1.b65acp+2,
  -0x1.5e0c1ep-3,
  0x1.10cb7p+3,
  -0x1.658ecap-3,
  0x1.43e2f6p+0,
  -0x1.bc6366p+2,
  0x1.665548p-1,
  -0x1.11cd7p-1,
  0x1.173eep+0,
  -0x1.4e1d58p+2,
  0x1.7494ccp+1,
  -0x1.26d708p+4,
  -0x1.34c074p+1,
  0x1.85edc2p+1,
  0x1.a79a8ep+1,
  -0x1.628072p-3,
  0x1.f8daep-3,
  0x1.84fe96p-2,
  0x1.5b45f4p-2,
  -0x1.58870cp-3,
  -0x1.37ba3ep+2,
  -0x1.653a8ep-1,
  0x1.719f5cp-2,
  -0x1.2e786ep+1,
  0x1.662788p+2,
  0x1.dba64p+2,
  -0x1.aca33ap+2,
  0x1.b3223ap+2,
  -0x1.23a97ap+2,
  -0x1.b5b582p+2,
  0x1.1b9cccp-2,
  -0x1.7753bp-2,
  0x1.5e542p+2,
  -0x1.5abfp+1,
  0x1.dd8a8ap+2,
  -0x1.b41d7ep+1,
  -0x1.65a87p-4,
  0x1.3966eap+3,
  -0x1.81735ap+2,
  0x1.b46238p-1,
  -0x1.aa568ep+2,
  0x1.37a5bp+3,
  0x1.e3p-4,
  0x1.97a2f6p-1,
  0x1.334cep+0,
  0x1.90b7aep-3,
  0x1.0d89fap+1,
  0x1.6231ccp+2,
  -0x1.614f2p+0,
  0x1.34f15cp+0,
  -0x1.6d631ap+1,
  0x1.ba88d2p+2,
  -0x1.3f0d44p+3,
  0x1.aff8bp-4,
  0x1.05c3d6p+1,
  0x1.407924p-1,
  -0x1.52616cp+0,
  0x1.bcbf28p+2,
  -0x1.48f218p+2,
  0x1.3f457p+0,
  0x1.ecbac4p-4,
  0x1.9088bap-2,
  -0x1.d4d294p+2,
  -0x1.620106p-3,
  0x1.487b7cp+3,
  0x1.3c89f8p-2,
  -0x1.82a98p+2,
  0x1.f69746p+0,
  0x1.cf72b6p+2,
  -0x1.6460cep-3,
  -0x1.813142p+1,
  -0x1.7d2a9cp+2,
  0x1.ebf4eep+2,
  0x1.bbc7fcp+2,
  -0x1.fc9bf2p+1,
  -0x1.abd912p-1,
  -0x1.181baep-1,
  -0x1.376852p-3,
  0x1.2f9d3ap+2,
  0x1.a43f72p+2,
  0x1.10cd82p+3,
  0x1.330766p-7,
  0x1.9c7abap-2,
  -0x1.1d151ap+4,
  0x1.0420aep+2,
  -0x1.1c82d8p-4,
  0x1.03f97p-1,
  -0x1.9ce762p-2,
  -0x1.01d9a8p+1,
  0x1.bc5b9ep-3,
  -0x1.b85dd4p+2,
  -0x1.5fbe3ep-3,
  0x1.a2fca8p-1,
  -0x1.f87332p-2,
  0x1.ffb102p-1,
  0x1.496214p+0,
  -0x1.830a7p+2,
  -0x1.0509fap-2,
  -0x1.53079ap+0,
  0x1.76198p+0,
  -0x1.5dbb76p-3,
  0x1.a46a9ep+1,
  -0x1.646f1ap+5,
  -0x1.ab75c8p+1,
  -0x1.b85902p-6,
  0x1.284bc2p+0,
  -0x1.62cc74p-3,
  0x1.c928cap+2,
  0x1.40b302p-2,
  -0x1.737232p+2,
  0x1.3a823cp-1,
  0x1.157b9ep+1,
  -0x1.a1ba3ep+4,
  0x1.f51844p+2,
  0x1.b43bdep+2,
  0x1.142676p+2,
  -0x1.2d1b7ep+2,
  0x1.51213ep-2,
  0x1.7b7938p+2,
  -0x1.57e164p+1,
  -0x1.1f42a4p+1,
  -0x1.bedddep+1,
  -0x1.0501eap+2,
  0x1.c8d1fp+2,
  -0x1.7427cep+5,
  -0x1.167deep-1,
  0x1.820772p-3,
  -0x1.f0b1dap+1,
  0x1.87c9e4p+2,
  0x1.6eeeeap+1,
  -0x1.a35f4ap+2,
  0x1.8ae50ap+0,
  -0x1.28cd7ap+1,
  0x1.3e18f6p+0,
  0x1.50b63p+2,
  0x1.36c114p+3,
  -0x1.00bc3p+1,
  -0x1.0a799p+3,
  0x1.3cc37p+0,
  0x1.8c48p-1,
  -0x1.0d831ep+1,
  0x1.ce8994p+2,
  0x1.745a2ep+1,
  0x1.36a8p+3,
  -0x1.1a770ap+1,
  -0x1.86528ep-1,
  0x1.47be68p+3,
  -0x1.0eb4f6p+0,
  -0x1.611df2p-3,
  0x1.46c5ecp+3,
  -0x1.e55996p-10,
  -0x1.5e20e4p-3,
  -0x1.60f51ep-1,
  -0x1.49bcp+2,
  0x1.649348p+1,
  0x1.87a4aep-4,
  -0x1.7aa58cp+2,
  0x1.8cf99ap-4,
  0x1.bd5326p+2,
  0x1.8ce666p+0,
  -0x1.6bff88p-1,
  0x1.d12a7ap+2,
  0x1.7dc29cp+2,
  0x1.421e8ap+3,
  -0x1.656186p-3,
  -0x1.1fa2e2p+1,
  0x1.dfd894p+2,
  -0x1.e24b84p-1,
  -0x1.08b8c2p+0,
  -0x1.b3cd68p+2,
  -0x1.5b7acep-3,
  0x1.e3432ap+2,
  -0x1.58e15cp+2,
  -0x1.0d7ad6p+3,
  0x1.a8262ep-3,
  -0x1.55364ap+2,
  -0x1.b95818p+1,
  -0x1.5263c2p+1,
  -0x1.43d4ccp-1,
  -0x1.ccb046p+3,
  -0x1.f4969ap-1,
  -0x1.3bcb7ep-2,
  -0x1.2f32cp+2,
  -0x1.61303ap-3,
  -0x1.df2826p-1,
  0x1.5e9fc2p+2,
  0x1.d03e14p-4,
  0x1.42320cp+3,
  -0x1.aa2f4p+2,
  -0x1.f3d52ap+0,
  -0x1.818c72p-2,
  0x1.32d08ep+2,
  -0x1.c332p+0,
  0x1.dc5dc2p+0,
  0x1.1c7358p-1,
  -0x1.3adfd8p-1,
  0x1.113bap+0,
  -0x1.5b65a6p-3,
  0x1.36437cp+3,
  0x1.bb8dbap+2,
  -0x1.c46d9p+1,
  -0x1.c678d6p-1,
  0x1.3c9146p+3,
  0x1.485612p+3,
  0x1.f87d98p-1,
  -0x1.bf2d5cp+0,
  -0x1.cd2c2ap+2,
  0x1.829d9ap-1,
  -0x1.a95bd8p+2,
  0x1.a857aep+0,
  -0x1.03261cp+2,
  -0x1.8657d6p-1,
  0x1.50b348p+0,
  0x1.d615fp+2,
  0x1.8b0548p-5,
  -0x1.d0aa84p+1,
  -0x1.9b93cap+2,
  -0x1.595412p-3,
  0x1.b6ab74p-2,
  0x1.16c592p-2,
  0x1.cccc72p+1,
  -0x1.657c7p+1,
  0x1.aa995cp+2,
  -0x1.fa172ep+1,
  -0x1.12a886p+2,
  -0x1.9173d8p+2,
  0x1.9c3ca8p-3,
  0x1.e796ccp+0,
  0x1.182396p-3,
  -0x1.4291dap-4,
  -0x1.62f536p-3,
  0x1.7216e8p+2,
  0x1.cb45c8p+2,
  -0x1.497518p+2,
  -0x1.351996p+1,
  -0x1.0dfe32p+2,
  0x1.3bfc3cp+0,
  -0x1.39bd7p-6,
  -0x1.3a197ap+1,
  -0x1.830bc2p+2,
  0x1.b3857ep-5,
  -0x1.53f426p+2,
  -0x1.5f6ba2p-3,
  -0x1.4ed77ap+1,
  -0x1.556abp+2,
  0x1.9712p+1,
  0x1.0bf266p+0,
  -0x1.ad2376p+2,
  -0x1.af3504p+1,
  -0x1.76e7ep+2,
  -0x1.6562bap+1,
  0x1.843614p-2,
  0x1.384ef8p+3,
  -0x1.47a784p+0,
  0x1.f4a732p+2,
  -0x1.7ce922p+2,
  -0x1.336c52p+0,
  -0x1.48c65cp+1,
  0x1.494452p+3,
  -0x1.193914p+5,
  0x1.3577d2p+2,
  -0x1.63f1bep-3,
  -0x1.55d4d8p-4,
  0x1.d880eep-1,
  -0x1.7204ep+0,
  0x1.dbbb12p+2,
  -0x1.5e758ap-3,
  -0x1.21018p+1,
  0x1.06676ep+2,
  -0x1.646416p-3,
  0x1.03d04p+2,
  0x1.10cb02p+3,
  -0x1.6987b8p+1,
  -0x1.fb44dp+0,
  0x1.0e49ecp+1,
  -0x1.ae974ap+2,
  -0x1.8170a4p-9,
  -0x1.a49d78p+1,
  0x1.f48614p-2,
  0x1.c3c598p+0,
  0x1.5b5d38p+2,
  -0x1.e7e994p+1,
  -0x1.5ffb9ap-3,
  -0x1.1b21bp+3,
  -0x1.71927p+1,
  -0x1.5b87aep-3,
  0x1.106eccp+2,
  0x1.3e7aep-4,
  0x1.36a5d8p+3,
  0x1.1e7f48p+0,
  -0x1.6caff6p+2,
  0x1.91cf84p-1,
  -0x1.34c43cp+1,
  -0x1.594ad2p+2,
  0x1.dd37d4p+2,
  0x1.f073e8p+2,
  0x1.cef936p+2,
  -0x1.bab5acp-2,
  -0x1.035e0ap+0,
  0x1.6d44ccp-2,
  -0x1.1c4808p+2,
  -0x1.e8786ap+1,
  0x1.388c7cp+3,
  0x1.8766aep+1,
  -0x1.5eaeb6p-3,
  -0x1.64b42cp-3,
  -0x1.027faep-1,
  -0x1.ba8b4ep+1,
  0x1.266edap+2,
  0x1.9fd6c2p+2,
  -0x1.a44034p+1,
  0x1.78abccp+1,
  0x1.377b5p+3,
  -0x1.940a02p+1,
  -0x1.fdb2bcp+0,
  -0x1.65ae92p-3,
  0x1.a521c8p+3,
  -0x1.4749aap+3,
  -0x1.c1a2dep-1,
  -0x1.7f4bfep+3,
  0x1.3f9db8p+3,
  0x1.6c7c0ap+2,
  0x1.82779cp-1,
  -0x1.824e0ep+2,
  0x1.fec4ccp-2,
  0x1.e58412p+2,
  -0x1.578fc8p+3,
  0x1.0ccf34p-2,
  -0x1.6173bcp+0,
  -0x1.f7357p+0,
  0x1.f3e768p+2,
  0x1.4317e2p+3,
  -0x1.0f5222p+1,
  -0x1.e5895ep-5,
  0x1.d298dep+2,
  0x1.c86c1ep+2,
  0x1.459134p+3,
  -0x1.553b7ap-3,
  -0x1.05c35cp+0,
  0x1.4461bcp+2,
  0x1.9bc9eap-4,
  0x1.06295cp+0,
  0x1.43d93ep+3,
  0x1.556832p+2,
  0x1.f4b8d6p+1,
  -0x1.465f64p+1,
  -0x1.614fdep-3,
  -0x1.b5350ep-3,
  0x1.9f56p+0,
  0x1.454eb6p+3,
  -0x1.fba2cep+1,
  -0x1.5f303cp-3,
  0x1.6ceed2p+0,
  0x1.58255cp+2,
  0x1.b69528p+1,
  0x1.7177ep+3,
  -0x1.a45ad8p-1,
  -0x1.94f706p+0,
  -0x1.be9e04p+2,
  0x1.5bf948p+0,
  0x1.10cacep+3,
  -0x1.740c94p+2,
  -0x1.09bff6p+1,
  0x1.3671c4p+3,
  0x1.bec15cp+2,
  -0x1.6346d4p+2,
  0x1.bd4e1cp+2,
  0x1.82d99ap-1,
  -0x1.8225a8p+2,
  0x1.220a66p-2,
  -0x1.e16c52p-1,
  -0x1.35848ep-1,
  0x1.e11384p-2,
  -0x1.8d8592p+0,
  0x1.4c29bcp+1,
  0x1.387af8p+2,
  0x1.8d8fd6p-1,
  0x1.c7d02ep+2,
  -0x0p+0,
  0x1.38ec96p+3,
  -0x1.306a06p+2,
  -0x1.59c33ep-3,
  0x1.6d72f4p+0,
  -0x1.cf944cp+2,
  -0x1.5dac8cp-3,
  0x1.acda6p+2,
  -0x1.e3cbf2p+1,
  -0x1.0cdac4p+0,
  0x1.390014p+2,
  -0x1.64fceep+2,
  -0x1.82edfep+2,
  -0x1.3ea13cp+3,
  -0x1.0b4e5cp+1,
  0x1.01028ep-5,
  -0x1.2bb428p-2,
  0x1.00128p+0,
  -0x1.7adbfap-1,
  0x1.e535f2p+2,
  -0x1.648a8cp-3,
  0x1.e84186p+2,
  -0x1.6321p+0,
  -0x1.0a5654p+3,
  0x1.124c1cp-2,
  0x1.bba78ep+2,
  0x1.4531d8p+3,
  0x1.1bf358p+0,
  0x1.6cf66p+1,
  -0x1.033dc6p+2,
  0x1.4311aap+3,
  -0x1.766bdcp-3,
  0x1.828456p+2,
  0x1.3e467ap+3,
  -0x1.7fcebep-2,
  -0x1.432faep-1,
  -0x1.924aaep+1,
  -0x1.646662p+2,
  -0x1.892088p+0,
  -0x1.2b8eb8p+0,
  0x1.50170ap-5,
  0x1.50ad28p+1,
  0x1.e2ca16p+2,
  0x1.c2a97cp-1,
  -0x1.613492p-3,
  -0x1.7c95f4p+1,
  -0x1.b20d22p+0,
  0x1.713644p-2,
  0x1.f59c7ap-2,
  0x1.07cd36p+2,
  -0x1.467f64p-2,
  -0x1.01f75cp-2,
  0x1.54450cp-2,
  -0x1.cd8dc2p-1,
  0x1.441b4ap+3,
  -0x1.a839b6p+2,
  0x1.6a2932p+0,
  -0x1.3345ecp-1,
  0x1.d0f1dep+2,
  -0x1.657a4cp-3,
  -0x1.408364p+2,
  -0x1.01883ep+1,
  0x1.fe29aap-4,
  0x1.924d0ap+0,
  -0x1.5d1a3cp-2,
  0x1.c7d03cp+2,
  0x1.d03b78p+2,
  0x1.0b450ep+0,
  -0x1.e230c4p+1,
  -0x1.baa6ep-1,
  0x1.75c21ep+2,
  0x1.30bcbcp+0,
  -0x1.8f395cp+2,
  0x1.d0c2aep+2,
  -0x1.64f59ap-3,
  -0x1.ea3c2ap+1,
  -0x1.0506c6p+2,
  0x1.67c7fp-2,
  0x1.1b8feep+2,
  -0x1.1b0498p+3,
  0x1.451682p+3,
  0x1.76a29p-1,
  -0x1.2162d4p+4,
  -0x1.7e93c8p-4,
  -0x1.afffd6p+2,
  0x1.f2p-7,
  -0x1.8c62bep+5,
  0x1.effbep+2,
  0x1.d1b852p+2,
  0x1.5cdbd2p+0,
  0x1.c06b2p-1,
  -0x1.b33b84p-2,
  0x1.71d7c2p+0,
  -0x1.64c27ap-3,
  -0x1.3ea13cp+3,
  -0x1.7d82b2p+2,
  0x1.aa6d0cp+2,
  -0x1.ed7f5p-4,
  -0x1.e8264ep+2,
  -0x1.ae1c56p+2,
  -0x1.7abe24p+2,
  0x1.4236f4p+3,
  -0x1.c2268cp-2,
  0x1.6114aep+1,
  -0x1.60f716p-3,
  -0x1.09918ap+0,
  0x1.1c06a4p+0,
  0x1.860c26p-2,
  0x1.c42886p+3,
  -0x1.3447aep-5,
  -0x1.db094cp+3,
  -0x1.6dcbep+2,
  -0x1.4ec2dep-2,
  0x1.45b736p+3,
  0x1.3ff3dp-1,
  -0x1.bcfd2ap+2,
  -0x1.8854acp+2,
  -0x1.a0ff42p+0,
  0x1.04fab8p-1,
  -0x1.30bp-2,
  0x1.407192p+3,
  -0x1.79ac6ap+2,
  0x1.2277cap-1,
  0x1.35f784p+3,
  -0x1.35df54p+2,
  -0x1.610686p-3,
  -0x1.64178ep-3,
  -0x1.65b712p-3,
  0x1.10795cp+0,
  0x1.8ab654p+2,
  0x1.37e6dcp+3,
  0x1.4375bep+3,
  0x1.98562p+2,
  0x1.e2c1a8p+2,
  0x1.53f1ecp-1,
  -0x1.0c4b76p+1,
  -0x1.54a9ep+2,
  0x1.84b444p+3,
  0x1.a738a4p+0,
  0x1.95b5e4p+2,
  -0x1.eda14p+1,
  0x1.9f4bb6p+2,
  0x1.ff370ap-1,
  0x1.443dbcp+3,
  0x1.7780ccp-1,
  -0x1.968c9ap+1,
  0x1.6612fap+2,
  0x1.7b6bdep+2,
  -0x1.5b9b7cp-3,
  0x1.8679b8p-1,
  0x1.456d38p+3,
  -0x1.b3db5cp-1,
  0x1.9c6b3cp+1,
  0x1.96479cp+0,
  -0x1.814ec8p+2,
  -0x1.6dcb18p+2,
  0x1.110848p-2,
  -0x1.1f7ffp+1,
  -0x1.e60428p+1,
  0x1.6bea2ep+1,
  0x1.21c3d4p-1,
  -0x1.d0723ap+2,
  -0x1.2b0ccap-1,
  -0x1.ed681cp+1,
  0x1.5423d6p-4,
  0x1.43c694p+1,
  0x1.335p+0,
  -0x1.551ee4p-3,
  -0x1.7961eep+2,
  -0x1.10339cp+2,
  0x1.62a75ep-4,
  0x1.d3e368p+2,
  -0x1.c5a18ep+1,
  -0x1.2da37ep+6,
  0x1.9fd6ep+0,
  -0x1.617842p+2,
  0x1.7ceeb8p-3,
  0x1.c1b256p-1,
  -0x1.04dbfp+5,
  -0x1.c276c6p+0,
  -0x1.667c36p+2,
  -0x1.700c48p+2,
  0x1.0174ecp+0,
  -0x1.e1e5f8p-1,
  0x1.e5b97p+2,
  0x1.797d68p+2,
  -0x1.2b722ap+0,
  -0x1.143b4ap+3,
  0x1.437d6ep+3,
  0x1.942202p-4,
  -0x1.06013ep+1,
  -0x1.e739p+2,
  0x1.369ddap+3,
  -0x1.6f15eap+2,
  0x1.231e36p+2,
  -0x1.f77b84p+0,
  -0x1.68ed1ep+0,
  -0x1.84c91ap+4,
  -0x1.e6819cp-2,
  0x1.a0c1e6p+2,
  -0x1.80a3ecp+0,
  0x1.ce8948p-2,
  -0x1.e6dc46p+1,
  0x1.bbde32p-5,
  0x1.0ef40cp+2,
  -0x1.5f668p-1,
  -0x1.99b3a4p+2,
  0x1.497064p+3,
  -0x1.96d5f6p+2,
  -0x1.2db79p-5,
  -0x1.5b661ep-3,
  0x1.5f1226p+2,
  0x1.cd7992p+2,
  -0x1.5c4c9ep+2,
  0x1.860548p+0,
  0x1.3d40ep+3,
  0x1.1e676ep+2,
  0x1.7a52e6p-2,
  -0x1.5ecea6p+0,
  0x1.53567ap+2,
  -0x1.78bf34p-1,
  0x1.430f92p+3,
  -0x1.26b57p-2,
  -0x1.81b49p+2,
  -0x1.7949ep+0,
  -0x1.58403ep-3,
  0x1.941b48p+0,
  -0x1.508df4p+2,
  0x1.99ca4ap-2,
  -0x1.944b84p-3,
  0x1.36bb82p+3,
  0x1.2b7daep+0,
  -0x1.3b6ed8p+2,
  0x1.18abep-2,
  -0x1.f359d6p+0,
  -0x1.8d59fep-2,
  0x1.175bd4p-1,
  -0x1.7bb492p+2,
  -0x1.6c687ap+0,
  -0x1.6551b2p-3,
  -0x1.1077aep-2,
  -0x1.23a6d6p+1,
  -0x1.7c9692p+2,
  -0x1.649712p-3,
  0x1.71726ap+1,
  -0x1.10ac4ep+3,
  0x1.3a74a6p+0,
  0x1.6e98a4p-1,
  0x1.b7dc68p-2,
  -0x1.c34fbep+1,
  -0x1.9b2efap+2,
  0x1.64fc28p+1,
  -0x1.08275ep+0,
  -0x1.90b768p+1,
  -0x1.04687ap+0,
  0x1.022a3ep-2,
  0x1.31d856p+2,
  -0x1.1916a6p+2,
  -0x1.071b6p+5,
  0x1.580aeep+2,
  -0x1.0e753ep+1,
  0x1.6d8e6ep+0,
  0x1.afc04p+2,
  -0x1.0c5c88p+2,
  -0x1.0b0094p+2,
  -0x1.a9374cp+2,
  -0x1.389e9ap-4,
  -0x1.9e1a66p+0,
  0x1.2917a4p+2,
  0x1.4516a4p+0,
  -0x1.58d6d2p-3,
  -0x1.8d3282p-1,
  0x1.9ce2acp+3,
  0x1.75f332p-1,
  0x1.ab3d0ap+0,
  -0x1.75513ep+3,
  0x1.b4056ap+1,
  0x1.accf0ap+0,
  -0x1.648446p-3,
  0x1.b6284ap+2,
  0x1.0a73e6p+3,
  -0x1.8f931ep+0,
  -0x1.653ab4p-3,
  -0x1.a07646p+2,
  -0x1.838fcep+2,
  -0x1.1fcca4p-1,
  0x1.3f8acp+3,
  -0x1.e72a6p+2,
  0x1.53451ep-3,
  -0x1.21bf8p-1,
  0x1.477cccp+0,
  -0x1.1f2f32p-1,
  0x1.65303cp+0,
  0x1.43e608p+3,
  -0x1.c06e3cp+0,
  0x1.b3408ep+0,
  -0x1.5b09dp-2,
  -0x1.2f482ep+2,
  -0x1.358416p+2,
  -0x1.d2b2ap+2,
  -0x1.1883d6p+2,
  0x1.d2229cp+2,
  -0x1.35c1a2p+1,
  -0x1.8bb666p+3,
  -0x1.1d2eb6p+3,
  -0x1.600dp-3,
  -0x1.1c721p+3,
  -0x1.644118p+2,
  0x1.9f08ap+2,
  0x1.8c13d4p+2,
  0x1.35c95p+3,
  0x1.80d7cap+2,
  -0x1.58caa4p-2,
  0x1.4628p-2,
  -0x1.27d56ep+0,
  0x1.380e6cp+3,
  0x1.8539aap+2,
  -0x1.56efep+1,
  -0x1.ef1648p-1,
  -0x1.8549eep+2,
  0x1.155e12p+4,
  -0x1.53d3bap-3,
  -0x1.9c7e88p+2,
  0x1.d688fcp+2,
  -0x1.54807ep-3,
  -0x1.7436b8p-2,
  0x1.6ca666p-1,
  -0x1.6c77b6p-1,
  0x1.37fa42p+3,
  -0x1.98f9eep+1,
  0x1.1b44p+0,
  -0x1.3277eep-1,
  0x1.0da99ap-2,
  0x1.9c6892p+2,
  -0x1.c47754p+2,
  0x1.a31352p-4,
  0x1.71f8p-1,
  -0x1.22ff28p+1,
  0x1.374108p+3,
  0x1.b5cd8ap+1,
  -0x1.5b3f32p-3,
  -0x1.56193ap-3,
  -0x1.2fdd8ap+4,
  -0x1.5956b2p+2,
  -0x1.772006p+1,
  -0x1.5a291cp-3,
  0x1.2124fcp+2,
  0x1.d378fp+2,
  0x1.76b3f4p-3,
  0x1.00387ap+0,
  -0x1.362686p+2,
  0x1.451ba6p+3,
  -0x1.066914p+1,
  0x1.213ddap+0,
  -0x1.6f10d2p+2,
  -0x1.ecab64p-6,
  0x1.b96d0cp+2,
  -0x1.63cd96p-3,
  0x1.366b4cp+1,
  0x1.31a756p+0,
  -0x1.c721c6p-5,
  -0x1.6ed70ap-6,
  0x1.24ab92p-3,
  -0x1.47a3aep-1,
  0x1.950d6p+2,
  -0x1.57ffb6p-3,
  0x1.c9c3aep+0,
  0x1.d7bf4p+2,
  -0x1.2814f6p+0,
  -0x1.60f6cep-3,
  -0x1.62a2fep-3,
  0x1.d818ccp-1,
  0x1.76c47ap-3,
  -0x1.5b8674p+2,
  -0x1.d5f9dep+2,
  0x1.620a42p+2,
  0x1.b6d2d6p+2,
  -0x1.4b037p+0,
  -0x1.a0735cp-1,
  -0x1.272cf6p-1,
  -0x1.14c35cp-1,
  -0x1.d9620ap-1,
  0x1.f2921p-1,
  0x1.7784f6p+1,
  0x1.ba38f6p-3,
  -0x1.cecfdep+2,
  -0x1.13b832p-5,
  0x1.d4f442p+2,
  0x1.b36cap+2,
  0x1.500062p-1,
  -0x1.04dc5cp+1,
  -0x1.5e9754p+2,
  -0x1.b961p-6,
  -0x1.cfcfe6p+1,
  0x1.650866p+0,
  -0x1.545418p+3,
  -0x1.115a7ap+0,
  -0x1.99b554p+2,
  -0x1.ea403p-2,
  -0x1.6183a2p-2,
  0x1.919b5ap+2,
  -0x1.5afc4ap-3,
  0x1.ea9146p-2,
  -0x1.00c81ep+1,
  -0x1.4aa03ep+2,
  0x1.878edp-3,
  0x1.18dadap-4,
  0x1.60d8bcp+1,
  0x1.e9192cp-1,
  0x1.797b0ap+0,
  0x1.1dafa4p+0,
  -0x1.98f70ap-1,
  0x1.ae13c2p+2,
  -0x1.c9ffd6p-4,
  0x1.3cd90ap+0,
  -0x1.5638cep-3,
  0x1.448b38p+3,
  0x1.b5f5e4p+2,
  -0x1.27e222p+2,
  0x1.42a508p+3,
  -0x1.9a6a7p+2,
  0x1.36cbc2p+3,
  0x1.e9676p+1,
  0x1.95abdep+2,
  -0x1.666aep+0,
  -0x1.d48214p+0,
  0x1.d7d86ap+1,
  0x1.78e714p+1,
  0x1.a4161ep-2,
  -0x1.34e68ep-1,
  0x1.d5450cp+2,
  0x1.7e3dc2p-2,
  -0x1.92407ap+2,
  0x1.4418b4p+3,
  -0x1.763d3p+3,
  -0x1.116978p+3,
  0x1.9018aep+2,
  -0x1.80c9bep-2,
  0x1.5bec14p+0,
  -0x1.7ccf84p+0,
  0x1.44e018p+3,
  -0x1.279b7p+2,
  -0x1.2d08ap-1,
  0x1.bb4d8ep+1,
  0x1.be100ep-1,
  -0x1.5c1c3ap-3,
  0x1.4bf624p+2,
  0x1.adaa76p+2,
  -0x1.5cd68ep+0,
  -0x1.3185fp+2,
  0x1.3dee18p-4,
  -0x1.e395f8p-1,
  -0x1.e8528ap+2,
  -0x1.5b326ap+2,
  0x1.35bcbcp+3,
  -0x1.0802cp+5,
  0x1.fdab84p-2,
  -0x1.158152p-1,
  -0x1.5140c6p+3,
  0x1.14f5c2p+1,
  -0x1.a6f156p-1,
  -0x1.63d8b2p-3,
  -0x1.228ec4p+2,
  0x1.51173p-1,
  -0x1.c2abeep+2,
  -0x1.5f6792p+2,
  -0x1.88bfc2p+2,
  0x1.4a6decp+0,
  0x1.d0a6cp+2,
  -0x1.c10dccp+1,
  -0x1.60b94p+5,
  -0x1.3f78eep+3,
  0x1.f1b1ep+1,
  -0x1.404326p+2,
  0x1.9c6bd6p-2,
  0x1.4e963cp-4,
  0x1.1d26b4p+2,
  -0x1.37d952p+2,
  0x1.7eee38p+3,
  0x1.c5392ep+2,
  0x1.9128ap+2,
  0x1.9c8fd6p+2,
  0x1.be43d6p-2,
  -0x1.57f9e2p-4,
  0x1.434bacp+3,
  0x1.2d0f2cp-1,
  -0x1.ba23aap+1,
  0x1.3ae01cp+3,
  -0x1.95778ap+2,
  -0x1.c65b3cp+1,
  0x1.23ae7ap+1,
  -0x1.23d308p+2,
  -0x1.ba5c3cp+0,
  -0x1.d07b0ep-3,
  0x1.504052p-2,
  0x1.5e1a46p+0,
  0x1.95dd28p+2,
  0x1.897f68p+2,
  -0x1.56811ep+0,
  0x1.9b504p+2,
  0x1.034f02p+4,
  -0x1.6a872ap+0,
  0x1.eb077ap+2,
  -0x1.6b6004p+0,
  0x1.71ec28p-1,
  0x1.00a18ap+2,
  0x1.a65932p+0,
  0x1.f27e3cp+2,
  -0x1.683308p+0,
  -0x1.6de68ap+0,
  -0x1.f15cbap+2,
  -0x1.2390c2p+2,
  0x1.eeaa42p+2,
  -0x1.feccb4p+0,
  -0x1.234018p+4,
  -0x1.ffb332p+0,
  -0x1.8fbd1ep-1,
  -0x1.2666b8p-1,
  0x1.10c816p+3,
  -0x1.7fd956p-2,
  -0x1.073c3ap+3,
  -0x1.63a47cp+1,
  0x1.814d1ep-2,
  0x1.65d55ap-1,
  -0x1.64c9b4p-3,
  0x1.d9562ap+2,
  -0x1.60f91cp-3,
  -0x1.650866p-3,
  0x1.48178cp+3,
  0x1.e0d776p+2,
  -0x1.6f9418p+1,
  -0x1.1bf3ecp+0,
  0x1.f4717p-1,
  0x1.c791f6p+2,
  -0x1.525c08p-1,
  -0x1.62d062p-3,
  -0x1.eb511ep-2,
  -0x1.09cd3cp+0,
  0x1.3e45ap+3,
  0x1.301802p-1,
  -0x1.39bbdap+2,
  -0x1.c82196p+2,
  -0x1.303b3ap+4,
  0x1.8f4b08p+2,
  0x1.035eeep-2,
  -0x1.5fe326p-3,
  0x1.04028ep-5,
  0x1.d3fafcp+2,
  0x1.42ba5ap-1,
  -0x1.cdeb2ep+0,
  -0x1.7500a8p+2,
  0x1.7dbbbcp+0,
  -0x1.f4eb86p+2,
  0x1.7c47aep-6,
  0x1.75b67p-2,
  0x1.8d873ap+2,
  0x1.5bccacp+0,
  -0x1.e151a8p+0,
  -0x1.51474ep-2,
  0x1.c0ea9ep+2,
  -0x1.a23e0ep+2,
  -0x1.011accp+0,
  -0x1.dde764p+4,
  -0x1.da003cp+0,
  -0x1.b005c2p-4,
  0x1.43b4aep+3,
  0x1.869f5cp+1,
  -0x1.f8e706p+0,
  -0x1.55077ap+1,
  -0x1.136deap+2,
  -0x1.0376a6p+3,
  0x1.f668f6p-3,
  0x1.17f31ep+0,
  0x1.ab83d8p-1,
  -0x1.534404p+4,
  -0x1.63de7cp-3,
  -0x1.1cfap+0,
  0x1.576bd6p+0,
  -0x1.4463a4p+2,
  -0x1.65a27cp-3,
  0x1.b13052p-2,
  0x1.d483a4p+2,
  -0x1.02d042p+1,
  -0x1.60fa9cp-3,
  -0x1.16e87ap-1,
  0x1.b492b8p+0,
  -0x1.a4cf6ep+2,
  0x1.19af4cp+1,
  0x1.7e8bc2p+2,
  -0x1.29775p+1,
  -0x1.4cccccp+1,
  0x1.167266p+0,
  -0x1.647cccp+1,
  0x1.1debfap+1,
  -0x1.4e9166p-3,
  0x1.87c92ap+0,
  -0x1.3ea13cp+3,
  0x1.8976ccp+0,
  0x1.6c7384p+0,
  -0x1.5b557cp-3,
  -0x1.30c126p+1,
  -0x1.639d72p-3,
  -0x1.4c44ap+2,
  -0x1.6ea332p+1,
  0x1.8e982ap+2,
  -0x1.81006p+2,
  0x1.1d4be4p+4,
  -0x1.ec89fcp-1,
  -0x1.503f1ap+2,
  0x1.e57e76p+2,
  -0x1.5ddcaap-1,
  0x1.439434p+3,
  -0x1.4a897ap+2,
  -0x1.939222p+2,
  -0x1.3da46cp-4,
  -0x1.58bf08p+2,
  -0x1.3eaadep+3,
  -0x1.aab2eep+2,
  -0x1.7c5af6p-1,
  0x1.bf4fccp+2,
  0x1.10cd1ep+3,
  0x1.fa0198p-1,
  -0x1.ca7dc2p-4,
  0x1.894544p+2,
  0x1.442d5ep+3,
  0x1.371242p+3,
  -0x1.95fba6p-1,
  0x1.d1a67p+2,
  0x1.769918p+0,
  0x1.4e61c2p-1,
  -0x1.57c1ep+1,
  -0x1.d74902p+0,
  -0x1.3ea13cp+3,
  -0x1.851e32p+2,
  0x1.247602p+2,
  0x1.3f0314p+1,
  -0x1.637aep-2,
  0x1.41b1fap+3,
  -0x1.04efc6p-3,
  -0x1.88130cp+2,
  -0x1.b2a146p+2,
  0x1.54bb5ep+3,
  -0x1.a06ap+0,
  -0x1.569e66p+0,
  0x1.2a59a8p+4,
  -0x1.6105fap-3,
  -0x1.82a98cp+1,
  0x1.a428f2p+2,
  -0x1.8bb3eap+0,
  -0x1.627f62p-3,
  0x1.b0f5c2p-9,
  -0x1.469442p+1,
  0x1.4507e8p+3,
  -0x1.86afacp+2,
  0x1.da41f8p+2,
  -0x1.eece8ep-1,
  -0x1.03cddp+1,
  -0x1.225768p+4,
  -0x1.51a33ap+2,
  0x1.24c926p+0,
  0x1.7b8ad4p+2,
  -0x1.17bebcp-2,
  0x1.ac0e14p-3,
  -0x1.82f9f6p+2,
  -0x1.5e5b3p-1,
  -0x1.805ffcp+2,
  -0x1.600742p-3,
  -0x1.887c68p-3,
  -0x1.615aacp-3,
  -0x1.7ba8fep+4,
  0x1.f6370ap-4,
  -0x1.e06b9p+2,
  -0x1.5fbfb2p-3,
  0x1.aaa50ep+2,
  -0x1.8176fep+2,
  0x1.5ce1d2p+0,
  0x1.b23e64p-1,
  -0x1.aea0ep+0,
  -0x1.26c00cp+2,
  -0x1.5a23bap+2,
  -0x1.55a02ep-3,
  0x1.350bap+3,
  -0x1.9b4ec6p+1,
  0x1.e0a52ep+2,
  -0x1.74fe26p+2,
  -0x1.1d92c2p+1,
  -0x1.5da7d6p-1,
  -0x1.312282p+1,
  -0x1.62c91cp-3,
  -0x1.c173f8p-1,
  -0x1.9f0316p-1,
  -0x1.4ba776p+2,
  0x1.cb445ep+2,
  -0x1.7efb5cp-1,
  0x1.4595cap+3,
  -0x1.5bcf12p-3,
  0x1.c3b3d6p-3,
  -0x1.cb85d8p-3,
  -0x1.2824ccp-1,
  -0x1.a35d68p+2,
  -0x1.87e812p+2,
  -0x1.68cfd6p-1,
  -0x1.b44846p+2,
  -0x1.4cb4d4p+2,
  -0x1.058c1cp-2,
  -0x1.600046p-3,
  0x1.d80cb8p-2,
  0x1.babe66p+0,
  0x1.be9c56p+2,
  0x1.016978p-2,
  -0x1.a61fbp+2,
  0x1.6bd5f6p+2,
  -0x1.9e2b36p-2,
  -0x1.936c78p+2,
  -0x1.390932p+0,
  -0x1.c978ccp+0,
  0x1.4fbcccp-2,
  -0x1.605154p-3,
  0x1.00c70ap-2,
  -0x1.65c06cp-3,
  0x1.a6f552p+2,
  0x1.0f98p-1,
  -0x1.a673c6p+1,
  0x1.36420ap+3,
  0x1.20469p+2,
  0x1.da8c28p-1,
  -0x1.451f4ep+2,
  -0x1.c56adcp+2,
  0x1.c57f32p+0,
  -0x1.12477p-1,
  -0x1.3aa0aap-6,
  0x1.c60c24p+1,
  -0x1.6476acp-3,
  -0x1.6bbc9cp+2,
  -0x1.7e46b6p+1,
  -0x1.fae904p-3,
  0x1.b9451ep-4,
  0x1.4a5348p+0,
  0x1.aa0cp-1,
  -0x1.7b5694p+2,
  -0x1.59cb04p+2,
  0x1.47eaf2p+3,
  -0x1.61696cp-3,
  0x1.3b5cep+0,
  0x1.30facp+0,
  -0x1.7dfp-2,
  0x1.aefcfap+1,
  0x1.e5ae7cp+2,
  -0x1.9920aap+1,
  -0x1.410848p+1,
  0x1.7aa234p+1,
  0x1.5fe74cp+2,
  -0x1.07b5aep+0,
  0x1.8d2e4p-1,
  -0x1.5dc9bap-3,
  0x1.4edc32p-5,
  -0x1.5a747ap-4,
  -0x1.551516p-3,
  0x1.427c36p+3,
  0x1.d5762p+2,
  -0x1.a94422p+0,
  0x1.2813dp+0,
  -0x1.0aececp+2,
  0x1.430af8p+3,
  0x1.704334p+0,
  -0x1.6180ecp-3,
  0x1.9878cep+2,
  -0x1.5c8532p-3,
  -0x1.a0f696p+2,
  -0x1.63c81cp-3,
  0x1.5c9ccep+2,
  0x1.d0b332p+0,
  0x1.dd02fp+2,
  0x1.30824ap-4,
  0x1.f0ce3cp-1,
  0x1.375f9cp+3,
  -0x1.1b636cp+4,
  -0x1.c607ap+2,
  0x1.93b6f6p+0,
  -0x1.640b8ap-3,
  -0x1.ac8748p+0,
  -0x1.148e5ep+2,
  -0x1.60dfdep-3,
  -0x1.61688cp-3,
  -0x1.a87362p+2,
  -0x1.5d02d8p+3,
  -0x1.3692eep-1,
  0x1.ece852p-3,
  -0x1.01c6ep+0,
  0x1.be7a58p+2,
  -0x1.365372p-3,
  0x1.7dd0d4p-1,
  0x1.94f6ep+0,
  0x1.df5e8ap+2,
  -0x1.28cdf2p+0,
  -0x1.6547d2p-3,
  -0x1.cbe236p-4,
  -0x1.23dffep+1,
  -0x1.2b9e4ep+2,
  0x1.28ff22p+0,
  -0x1.5f1b8ep-3,
  -0x1.af4f5cp-2,
  -0x1.261c7cp+2,
  -0x1.940248p+0,
  -0x1.aa31eap-1,
  -0x1.17841ep+0,
  -0x1.a15b06p+1,
  0x1.852a0ap+2,
  -0x1.1d74a4p-1,
  0x1.3d8912p+3,
  0x1.def324p+2,
  0x1.3ba8eep+0,
  -0x1.5fbb8ep+0,
  0x1.55f48ep-2,
  -0x1.d12e1p+1,
  -0x1.591d24p-3,
  -0x1.f08bbcp-1,
  -0x1.d5aadp+2,
  0x1.d7b94p+2,
  0x1.4215ecp+3,
  -0x1.531ac8p+3,
  -0x1.785704p+2,
  0x1.cab5d6p+2,
  0x1.48437ap+3,
  0x1.fd2b46p-5,
  -0x1.640bfep-3,
  0x1.44d448p+0,
  -0x1.4bfd76p-1,
  0x1.49063p+3,
  -0x1.74b3a8p+3,
  0x1.7f4ca8p+1,
  0x1.55a30ep+1,
  0x1.2fc866p+0,
  -0x1.80e5eap+0,
  -0x1.2e49e2p+4,
  -0x1.89d538p+1,
  0x1.8012b8p+0,
  -0x1.651586p-3,
  -0x1.82af5cp+2,
  0x1.f1b0a4p-1,
  0x1.28e914p+1,
  -0x1.e08a7ap+0,
  0x1.10c9f4p+3,
  -0x1.64dbbcp-3,
  0x1.cfceb8p+2,
  -0x1.64e71ep+2,
  0x1.01c214p-1,
  -0x1.0cee7ap+2,
  0x1.66bb84p-2,
  -0x1.47ba7ap+5,
  0x1.ccb8e8p+2,
  0x1.d34b7cp+2,
  0x1.5828p+0,
  -0x1.9bf8c6p+2,
  -0x1.270aacp+2,
  0x1.445e38p+3,
  -0x1.c2af3p+2,
  0x1.73bcd6p-1,
  -0x1.5d3f7ap-3,
  -0x1.54c33ep+3,
  0x1.b0f92ep+2,
  0x1.54694ap+2,
  0x1.365b8ep-1,
  0x1.81712ep+1,
  -0x1.64de44p-3,
  0x1.8b28f6p-2,
  0x1.e79ceap+2,
  -0x1.790c14p+2,
  -0x1.0e76b8p+5,
  -0x1.7afc7p+2,
  0x1.bb846ep+2,
  -0x1.b1403cp+1,
  -0x1.86fe4cp+2,
  0x1.05ff34p+4,
  -0x1.861eb8p+0,
  0x1.6ee384p+0,
  -0x1.1d674cp-1,
  0x1.27cee8p-3,
  0x1.203dfcp+1,
  -0x1.94085p+1,
  -0x1.62fdf6p-3,
  -0x1.259494p+4,
  0x1.e7b2bap+2,
  -0x1.7ea7bcp-3,
  -0x1.3ea13cp+3,
  -0x1.287842p+2,
  -0x1.ab0f56p+2,
  0x1.d4ab54p+2,
  0x1.99c332p-3,
  0x1.2739aep+0,
  0x1.10cda8p+3,
  0x1.8c677p-1,
  0x1.792b74p-1,
  0x1.be6c56p+2,
  -0x1.003724p+2,
  0x1.ef91eap-3,
  -0x1.5fec66p+0,
  -0x1.3f348cp+2,
  0x1.899daep+0,
  -0x1.324956p+2,
  0x1.e44ee4p+2,
  -0x1.597012p-3,
  0x1.2af992p+0,
  -0x1.7569c8p+1,
  0x1.af3934p-4,
  0x1.808d1ep+0,
  -0x1.8d45e4p+2,
  0x1.463158p+3,
  0x1.3adp+0,
  0x1.ecdf32p+2,
  0x1.2aad9ap-3,
  -0x1.d803ecp-2,
  0x1.f03244p+2,
  0x1.9dc15cp+2,
  -0x1.b4c5cap-6,
  -0x1.659e44p-3,
  -0x1.798c8ap+1,
  0x1.c8d80ep+2,
  -0x1.47ae14p-6,
  -0x1.1e8216p+2,
  -0x1.5d407ep-3,
  0x1.13ee36p+2,
  -0x1.61244cp-3,
  -0x1.f2d01ep+1,
  -0x1.53e61ep-3,
  -0x1.1239ccp+1,
  -0x1.8d8168p+2,
  -0x1.585ed8p+2,
  -0x1.916e16p+1,
  0x1.a99198p-1,
  -0x1.936488p-1,
  0x1.424e58p+3,
  0x1.5e15c2p-1,
  -0x1.614486p-3,
  -0x1.a5a616p+2,
  0x1.3ef362p+3,
  -0x1.0dbee4p-4,
  0x1.03b99ap-2,
  -0x1.910a68p+3,
  -0x1.2fbfc2p+0,
  -0x1.59f8eap-3,
  0x1.7cec24p+1,
  0x1.1c27c2p+0,
  -0x1.de5f06p+2,
  0x1.7621c2p+0,
  -0x1.98de22p+1,
  -0x1.1f41d2p+1,
  0x1.adddaap+2,
  0x1.784fd8p-1,
  -0x1.5f00f2p+2,
  0x1.48dfc2p-1,
  0x1.7e3b1ep+0,
  0x1.8bc666p-3,
  0x1.37d0e2p-1,
  0x1.157c74p+2,
  0x1.6ff89ep+0,
  0x1.165ffep+0,
  0x1.d7529ep+2,
  0x1.44055ap+3,
  -0x1.6576e4p-3,
  0x1.b5bdc2p-2,
  -0x1.86a71p+2,
  -0x1.e0bb9ap+1,
  -0x1.3efb4ep+3,
  0x1.465b4ap+3,
  0x1.69ccccp-2,
  0x1.fa8332p+0,
  0x1.4f36aep-3,
  0x1.901bdcp+2,
  -0x1.93f8dap+1,
  -0x1.c6d308p-1,
  -0x1.8ab1e6p+2,
  0x1.3a40b8p+3,
  -0x1.347ff6p+1,
  -0x1.ab55b8p-3,
  0x1.2b15d2p+2,
  -0x1.78cb5p+2,
  -0x1.44fd58p+1,
  0x1.8874ccp+2,
  -0x1.95c6eap+2,
  0x1.6a9ad6p+2,
  0x1.5ac8p-2,
  -0x1.a31878p+1,
  -0x1.61f5eep-2,
  0x1.daa598p+2,
  -0x1.99370ap-1,
  0x1.8d1328p+2,
  -0x1.717428p-6,
  0x1.a4ac26p-1,
  -0x1.a8341ap+4,
  -0x1.3d9104p+2,
  -0x1.3461e8p+4,
  0x1.af6bd4p+2,
  0x1.ad2e52p+2,
  -0x1.5eb886p-3,
  0x1.4cc9c2p-1,
  0x1.363ce2p+3,
  0x1.cac2d4p+2,
  -0x1.64c11ap-3,
  -0x1.5bb654p-3,
  0x1.9cd41ep+2,
  0x1.a0c9fep-1,
  0x1.0f9018p-4,
  -0x1.669748p+0,
  0x1.b1023cp+1,
  0x1.d9e51ep-3,
  -0x1.860c04p+2,
  -0x1.004e04p+0,
  0x1.606e3cp+0,
  -0x1.3d5198p+2,
  0x1.e50c02p+3,
  0x1.175666p-2,
  -0x1.15400ap+1,
  0x1.d3df72p+2,
  0x1.8474f6p+2,
  -0x1.7beef6p-1,
  -0x1.234dfcp+1,
  0x1.a31fap+2,
  0x1.371dd2p+3,
  0x1.49ae1ap+1,
  0x1.09183cp+0,
  -0x1.9943fep+2,
  -0x1.65ae36p-3,
  -0x1.3f64f6p+2,
  0x1.a9d88cp-1,
  -0x1.108da4p+1,
  0x1.239b84p-1,
  -0x1.7a3fcap+1,
  0x1.2fb65cp-3,
  -0x1.c22adp-1,
  -0x1.4e4a96p+2,
  -0x1.b97532p-2,
  0x1.6a1b84p-1,
  -0x1.4acc7ep+2,
  0x1.597faep-2,
  -0x1.29e666p-4,
  -0x1.92f968p+2,
  0x1.b5bcbcp+2,
  0x1.d44a0ap+2,
  -0x1.118962p+0,
  -0x1.0963fcp-1,
  0x1.b49e72p+2,
  0x1.479932p+3,
  -0x1.96ebb8p+2,
  -0x1.17fd5ap+2,
  -0x1.30bf5cp-3,
  0x1.458e58p+3,
  0x1.36d3dap+3,
  0x1.498cc4p+0,
  0x1.a51dp+2,
  -0x1.76eaep-2,
  0x1.a92b5cp-1,
  0x1.1cb5c8p+1,
  0x1.f116dap-1,
  -0x1.2fefa4p+1,
  0x1.895384p-1,
  0x1.3ea70ap-1,
  0x1.4e5bc2p+0,
  -0x1.5d3056p-3,
  0x1.6e4f32p+1,
  0x1.a0cb4ap+2,
  0x1.3e9daep+0,
  -0x1.610884p-3,
  -0x1.e575c2p-4,
  -0x1.4aa4e4p+3,
  0x1.6b2384p-1,
  0x1.10ccccp+3,
  0x1.287d32p+0,
  0x1.3ecp-2,
  -0x1.ac3126p+2,
  -0x1.375428p-2,
  0x1.dd5e32p+2,
  -0x1.3cc38cp+5,
  -0x1.63b394p-3,
  -0x1.36dd2ap+0,
  -0x1.abaca4p-1,
  0x1.9a4998p-3,
  0x1.a8322ep+1,
  0x1.495ba8p+2,
  -0x1.2b1d96p+2,
  0x1.3cb612p+3,
  0x1.3b0bacp+2,
  -0x1.24da3ep+2,
  0x1.b4cc52p-1,
  -0x1.7231e6p+2,
  0x1.68579ap+0,
  0x1.98b34p+2,
  0x1.b0f174p+2,
  -0x1.19633p+1,
  0x1.4e8p-5,
  0x1.c0b04cp+2,
  0x1.3707a8p+3,
  -0x1.0e597ap+2,
  -0x1.cedcfep+4,
  -0x1.086438p+3,
  -0x1.a9c966p+1,
  -0x1.74d70ap-7,
  -0x1.641bbap-3,
  0x1.bbba02p+2,
  -0x1.348cccp-3,
  -0x1.660e72p-3,
  0x1.ace148p-4,
  -0x1.21da26p+0,
  0x1.46698ap+0,
  -0x1.1153b6p+0,
  -0x1.785416p+2,
  -0x1.fa611ep-1,
  -0x1.f9b342p-10,
  0x1.bc4b08p+2,
  -0x1.5b84eep-3,
  0x1.47768p+1,
  0x1.4c15c2p+0,
  -0x1.c77e56p+0,
  0x1.7d241ep+1,
  0x1.ae9d56p+1,
  0x1.969368p+2,
  -0x1.cae3fp+0,
  0x1.dd0f7ap+2,
  -0x1.60cbbcp-3,
  0x1.e8d8bap+2,
  -0x1.994098p+0,
  -0x1.4fca34p+3,
  0x1.c4a67ap+2,
  0x1.7d00ap+2,
  -0x1.c32c1p+2,
  -0x1.8632b6p+2,
  0x1.b1f5cep+2,
  -0x1.97022ep+4,
  -0x1.55a7ep+3,
  -0x1.d4fa1ep+2,
  0x1.5fff5cp-3,
  0x1.c1ca3ep-6,
  0x1.8f307ap-1,
  -0x1.43319ap-1,
  -0x1.ab6e94p-1,
  -0x1.a640ap-2,
  0x1.44e4e4p+3,
  -0x1.d568c8p+3,
  0x1.2f5ba6p+2,
  0x1.4371b2p+3,
  -0x1.63de96p-3,
  0x1.674f7ep+0,
  0x1.899e56p+2,
  -0x1.493136p+0,
  -0x1.be2b2ep+1,
  -0x1.01d56ap+2,
  -0x1.3d4ddp+5,
  0x1.479bf6p+3,
  -0x1.67a02ep-1,
  0x1.b4265cp+2,
  -0x1.07d2a4p+1,
  -0x1.85bb08p+2,
  0x1.d3d95cp+2,
  -0x1.6fd80cp+2,
  -0x1.141ed8p+0,
  -0x1.5e4264p-3,
  0x1.3ff1fp+2,
  0x1.3f5e2ap+1,
  -0x1.683c8ap+2,
  0x1.456ad2p+1,
  -0x1.203312p+2,
  -0x1.63533ap-3,
  -0x1.554ceap+2,
  -0x1.506d48p+2,
  0x1.f2cap-1,
  0x1.432124p+3,
  -0x1.6905d4p+2,
  0x1.a13008p+2,
  -0x1.61007cp-3,
  -0x1.80ada8p+2,
  -0x1.2b5e12p+2,
  0x1.0c38c6p-2,
  0x1.6bb408p+2,
  0x1.ee99c2p-1,
  0x1.3c9f7cp+0,
  -0x1.ca076p+4,
  -0x1.b9fd7p-2,
  0x1.d3c47ap-1,
  -0x1.2dadfp+2,
  -0x1.1f362p-4,
  0x1.6923dep+2,
  0x1.be923ap+2,
  -0x1.6cb73ep+2,
  -0x1.565dd6p-3,
  0x1.0d65ecp+0,
  0x1.8e8a76p+2,
  -0x1.9f02cep-4,
  0x1.43d63ep-1,
  0x1.36302cp+3,
  -0x1.0e3a4ep+1,
  -0x1.9a6fdap+2,
  -0x1.5ac962p-3,
  -0x1.2531c6p+1,
  -0x1.7803f8p+2,
  -0x1.527bccp-2,
  0x1.7c4c54p+2,
  0x1.3e060ep+2,
  -0x1.6f1faep+1,
  0x1.d71794p+2,
  -0x1.4ef87cp+0,
  0x1.34ebd6p-1,
  -0x1.bcdef2p-11,
  -0x1.7c89b4p+1,
  0x1.1dde7ap+0,
  0x1.070a4cp+2,
  0x1.944982p+2,
  -0x1.8fc20cp+2,
  0x1.0a54d2p-4,
  0x1.44068ap+1,
  -0x1.3682ccp+1,
  -0x1.6027b4p-3,
  -0x1.56433cp-3,
  -0x1.611a72p-3,
  0x1.f3e98p-2,
  0x1.d08a02p+2,
  -0x1.3caae2p-6,
  0x1.c20dbcp+2,
  -0x1.018d48p-1,
  -0x1.64ea72p+5,
  -0x1.8cf15cp+1,
  -0x1.7bd526p+2,
  0x1.910532p+0,
  0x1.876cccp-1,
  0x1.6b878ap+2,
  -0x1.631b5cp-3,
  0x1.b00e48p+2,
  -0x1.f2bbc8p+1,
  -0x1.45803cp+1,
  -0x1.5f5a66p-3,
  -0x1.96ce1cp+2,
  0x1.291652p+0,
  -0x1.d34f3ap+0,
  0x1.38998ep+0,
  0x1.ada72p-1,
  -0x1.237184p+0,
  -0x1.20ab84p+2,
  0x1.067852p-3,
  0x1.3cac66p+0,
  0x1.bccd8ep+2,
  0x1.252d84p+0,
  -0x1.32397ap+2,
  0x1.35fc82p+3,
  -0x1.70551ep-3,
  -0x1.813478p+4,
  0x1.3f75c4p+3,
  0x1.3f7dd6p+3,
  0x1.381c9ep+1,
  -0x1.fd3b32p-2,
  -0x1.2bb33cp-1,
  0x1.de544ap+2,
  0x1.772e6ap+0,
  0x1.a7acfap+1,
  -0x1.0615c6p+3,
  0x1.5b0bbcp+2,
  -0x1.9dd4a8p-2,
  -0x1.9f4442p+1,
  -0x1.d50b1ep+1,
  -0x1.56bf4ap-3,
  0x1.16945cp+1,
  -0x1.5ff37ap-3,
  -0x1.ffbccap+2,
  -0x1.384d24p+1,
  -0x1.b98b6cp+1,
  0x1.3a1936p+2,
  0x1.44faf8p+3,
  0x1.50b852p-8,
  -0x1.57888ep+2,
  0x1.489e2ap+3,
  0x1.7ef8eep-1,
  -0x1.242e6ep-10,
  0x1.b2a55cp+3,
  0x1.c89c72p+2,
  0x1.35d764p+3,
  -0x1.9e46p+0,
  -0x1.75e2f4p-3,
  -0x1.5c53c6p-3,
  -0x1.12715cp+0,
  -0x1.d39724p+2,
  -0x1.9a8eb8p+0,
  0x1.e68af6p+2,
  0x1.24099ep+1,
  0x1.8bc658p-1,
  0x1.a15c28p-7,
  -0x1.6294e6p-3,
  0x1.e64718p+2,
  -0x1.88c804p+1,
  -0x1.9198b6p+5,
  -0x1.283048p-1,
  0x1.ce516ap+2,
  -0x1.2b3baep+1,
  0x1.812d0cp+2,
  0x1.7ba71cp-1,
  0x1.47349p+0,
  -0x1.0b8e48p+4,
  -0x1.e6dfaep-2,
  0x1.440fa2p+3,
  -0x1.912c34p+2,
  -0x1.4bee34p+2,
  -0x1.ad47c8p-4,
  0x1.35fa32p+3,
  -0x1.8e0298p-1,
  0x1.48aaf6p+3,
  -0x1.0fe0d2p+0,
  -0x1.18fef6p-2,
  -0x1.e6b47ap+0,
  0x1.ca98aep+2,
  0x1.e2d266p-1,
  -0x1.351f76p+0,
  0x1.6d3c66p+2,
  0x1.ffcb3ep+0,
  -0x1.6d0c0cp+2,
  -0x1.3c1c28p-5,
  -0x1.c15cccp-3,
  0x1.98650ap+0,
  0x1.a6029ep+2,
  -0x1.9379f8p-3,
  0x1.3759e6p+3,
  0x1.5fdf7p+0,
  -0x1.6cc55ep+4,
  -0x1.053ee8p+2,
  0x1.4af0c8p+1,
  0x1.47654p+3,
  -0x1.2efceap-3,
  0x1.35a8bcp+3,
  -0x1.fc1d5ep-1,
  -0x1.459dfp+0,
  0x1.f8a8dep-1,
  -0x1.a7f5c2p-5,
  -0x1.9f3316p+1,
  -0x1.1aefp+2,
  0x1.36e29p+3,
  0x1.11eb7p+0,
  0x1.6532ep-1,
  -0x1.26974ep+1,
  0x1.acf71ep+1,
  -0x1.0aa7d6p-5,
  -0x1.9d2ad4p+0,
  -0x1.394222p+4,
  0x1.2d6428p+0,
  -0x1.b3fe3p-6,
  0x1.dbf61cp+2,
  -0x1.61fb7cp-3,
  -0x1.02cbep+1,
  -0x1.3d3f54p+0,
  -0x1.64d5bep-3,
  -0x1.9a6666p-5,
  -0x1.40a212p+4,
  -0x1.846292p+2,
  -0x1.257d9cp-1,
  0x1.e20d2ep+2,
  0x1.506cbap-1,
  -0x1.9f6c8ap-1,
  0x1.cb5852p-2,
  0x1.dfede8p+2,
  -0x1.df03d2p+1,
  -0x1.44c584p+1,
  -0x1.a3a42p+1,
  -0x1.2d988ap+1,
  -0x1.33a426p+4,
  -0x1.654542p-3,
  0x1.1e27bep+1,
  0x1.3faddap+3,
  -0x1.9066fp+1,
  -0x1.5c72dap-3,
  0x1.ac0814p+0,
  0x1.46ebd6p-1,
  -0x1.bc3a8ep+1,
  0x1.3104p+0,
  0x1.4c56fap+1,
  -0x1.742226p+0,
  -0x1.5c0486p-3,
  0x1.6285ecp+0,
  -0x1.c9b584p+0,
  0x1.e5955cp-3,
  -0x1.632452p-3,
  0x1.5bee1ep+1,
  0x1.3c2fb6p+3,
  0x1.16c592p-2,
  0x1.b295eap+2,
  0x1.407dcap+3,
  -0x1.767ef6p-1,
  0x1.eaf332p-3,
  -0x1.4c6c5p+2,
  -0x1.637f32p+1,
  -0x1.7f5e8ep-6,
  -0x1.65b23ap-3,
  -0x1.11900ap-1,
  0x1.10cef4p+3,
  0x1.d66a2ep+2,
  -0x1.3900ccp+2,
  0x1.b3f344p+2,
  -0x1.148232p+1,
  -0x1.3b252ep+2,
  0x1.da34a6p+2,
  -0x1.65a516p-3,
  -0x1.5ab462p+5,
  0x1.a73528p+2,
  -0x1.52d4dcp-2,
  -0x1.3f1bf4p+2,
  0x1.3d109cp+3,
  -0x1.e7b434p-3,
  0x1.4a8e1ap+0,
  -0x1.69edc2p-1,
  0x1.ad5e14p+0,
  0x1.366efp+3,
  -0x1.f320ep+3,
  -0x1.60c86ep-3,
  -0x1.062e96p+1,
  -0x1.a5e6b4p-1,
  0x1.48c082p+3,
  -0x1.54a50cp-1,
  -0x1.1d0e38p+1,
  -0x1.0d72cap-3,
  -0x1.c7214cp+4,
  0x1.cf20a8p+2,
  -0x1.42b7ecp+1,
  0x1.421b4p+3,
  -0x1.9509aep+2,
  -0x1.641eep+2,
  0x1.37c6f4p+3,
  -0x1.321a78p+2,
  0x1.c01464p+2,
  0x1.2ad612p+0,
  -0x1.baaeb4p-5,
  0x1.f1ba76p+1,
  -0x1.16b9aep+0,
  0x1.69f97p+0,
  0x1.d7236ep+2,
  -0x1.2655ecp+0,
  -0x1.b6036p+2,
  0x1.3bf742p+2,
  0x1.3a2338p+3,
  0x1.302f54p+2,
  0x1.b783cep+2,
  0x1.231e54p+2,
  0x1.b9a226p+2,
  0x1.3d6ec4p-4,
  -0x1.6605fep+2,
  -0x1.016e18p-15,
  0x1.7fb554p+2,
  0x1.bb8caep+2,
  0x1.397678p+3,
  -0x1.08edp+1,
  0x1.e85b2ep+2,
  -0x1.ba8f1ep+0,
  -0x1.600bc2p-3,
  0x1.4706b2p+2,
  0x1.76e914p+1,
  -0x1.d276ep-1,
  -0x1.fb3c58p+1,
  0x1.7fec7p+2,
  -0x1.488bf6p+5,
  0x1.3daea4p+0,
  -0x1.babc8ep+2,
  0x1.421582p+3,
  0x1.3b2066p+1,
  -0x1.ea428ep-3,
  0x1.c4b67ap-5,
  -0x1.4a9be6p+4,
  0x1.076be8p-2,
  0x1.979a26p+2,
  0x1.3fcdcp+3,
  0x1.3b8242p+3,
  0x1.8d651ep-4,
  0x1.b4919ap-2,
  -0x1.1a234ep-1,
  0x1.2fd148p-3,
  0x1.42871cp+3,
  0x1.97d77p+0,
  -0x1.86b75cp-2,
  0x1.9009a6p+2,
  0x1.408e7ap+1,
  -0x1.0fb01cp-7,
  0x1.a2f7d2p+2,
  -0x1.2cc04ap-5,
  -0x1.69a5ap+1,
  0x1.0bbc28p-2,
  0x1.2e22a2p+0,
  -0x1.88dc7ap-2,
  0x1.7c0c2p+2,
  -0x1.407b66p-2,
  0x1.d9152p+2,
  0x1.7002b4p+0,
  0x1.758778p+2,
  0x1.0dcfbap+2,
  -0x1.7f44bp+2,
  0x1.cd82p+2,
  -0x1.feb61ap+2,
  -0x1.1a4e4ep+2,
  0x1.e4a6a4p+1,
  -0x1.0b5fp+3,
  0x1.799eccp+1,
  -0x1.e3f07ap-1,
  0x1.38249cp+3,
  -0x1.bffb68p+1,
  -0x1.082034p+2,
  0x1.23fcd6p+1,
  -0x1.c101eep+1,
  -0x1.54d51ap-3,
  0x1.767064p+2,
  -0x1.9bc01ap-1,
  -0x1.29edc6p+2,
  -0x1.3877a4p+1,
  -0x1.61a294p-3,
  -0x1.bb793p+1,
  0x1.7a649ep+1,
  0x1.d2ed52p+2,
  0x1.48241cp+3,
  0x1.75e9c2p-2,
  0x1.42bcc4p+3,
  -0x1.cfdaaep+2,
  -0x1.858b18p+4,
  0x1.54595cp+0,
  0x1.0b3c52p+0,
  -0x1.d3180cp-1,
  0x1.58da68p+2,
  0x1.c6adp+1,
  0x1.a98beep+2,
  0x1.5c53b2p+1,
  -0x1.89d0ccp-1,
  -0x1.650562p-3,
  0x1.193d82p-1,
  0x1.5bca22p+3,
  0x1.3a05bp+3,
  0x1.161abcp+4,
  -0x1.71d802p+2,
  -0x1.02919ap+0,
  0x1.dc4546p-1,
  -0x1.f46284p+1,
  -0x1.8e38cep-2,
  -0x1.2b76d6p+1,
  0x1.b21856p+2,
  0x1.9c86e6p+2,
  -0x1.64d776p-3,
  -0x1.267618p+2,
  -0x1.53a72ap+2,
  0x1.dcabd6p-2,
  0x1.d42ac6p+2,
  0x1.45b8acp+3,
  -0x1.5c0da8p-1,
  -0x1.acc00ap+2,
  0x1.da4a46p+2,
  -0x1.64e686p-3,
  -0x1.729f8p+5,
  -0x1.194d9ap+3,
  0x1.7e3eb8p+0,
  -0x1.5ef7a2p-3,
  0x1.e443b2p+1,
  -0x1.7470dp+2,
  -0x1.3f927p+1,
  0x1.b096cp+2,
  0x1.b6792ap+2,
  -0x1.44742p+3,
  0x1.492384p+3,
  0x1.d3c576p-3,
  -0x1.11ab9ap+0,
  -0x1.e35b8cp-2,
  0x1.de41f6p-1,
  -0x1.2b6a16p-4,
  0x1.2d4eb2p+0,
  0x1.48aac8p+1,
  0x1.4450cap+3,
  0x1.35d076p+3,
  0x1.a536cep-1,
  0x1.735fbcp-1,
  0x1.b2e3d2p-1,
  0x1.775ab8p+2,
  0x1.819c92p-2,
  0x1.8f27cep+2,
  0x1.bb9e3ap+2,
  -0x1.4d9a94p+2,
  0x1.d7bcd8p+2,
  -0x1.1febecp+2,
  0x1.4d60e2p+3,
  -0x1.4b24d2p+3,
  -0x1.49a54cp-2,
  0x1.456e9ep+3,
  0x1.49f47ap-1,
  -0x1.63babep-4,
  0x1.b15424p+2,
  0x1.e115eap+2,
  -0x1.513732p+3,
  -0x1.35b7dep-2,
  -0x1.1bd7a4p+2,
  0x1.599a8ep+0,
  0x1.ad84aap-2,
  0x1.d976fcp+2,
  -0x1.86e666p-1,
  0x1.10cb48p+3,
  0x1.1d27fep+2,
  0x1.ea9446p+2,
  0x1.acbc8p+2,
  0x1.a6d17p+0,
  -0x1.100aa2p-3,
  -0x1.6dfbbep+5,
  -0x1.5b177p+0,
  0x1.9524f6p+0,
  -0x1.5aa4fap+2,
  0x1.6c782p+4,
  0x1.af708ap+1,
  0x1.cec838p+2,
  0x1.089898p+0,
  -0x1.63ccacp-3,
  0x1.1940bap+2,
  -0x1.14ca86p+1,
  -0x1.b5d494p+2,
  -0x1.0a319ap-2,
  -0x1.171efp+2,
  0x1.49beaap+3,
  -0x1.e727d4p+3,
  -0x1.234bcp-1,
  0x1.43c804p+3,
  -0x1.178dfep+2,
  0x1.fdc47ap-3,
  -0x1.e75396p+2,
  0x1.f8f04cp+2,
  0x1.3a2882p+3,
  -0x1.4fab3ep+2,
  0x1.952e04p+1,
  -0x1.f99bd6p+0,
  0x1.233548p+0,
  0x1.0fccccp-6,
  -0x1.54f26ap+2,
  -0x1.ea8732p-4,
  -0x1.44f526p+2,
  0x1.9dfe8ep+0,
  0x1.4df2ep-1,
  -0x1.5f4d08p+0,
  0x1.350aap+3,
  0x1.e7b63cp+2,
  -0x1.cba3f6p+1,
  0x1.3ec0f6p+0,
  0x1.b8a2bap+2,
  -0x1.5c199cp+4,
  -0x1.056936p+3,
  0x1.8e304p+2,
  0x1.b2fc28p-2,
  0x1.0af75cp-2,
  -0x1.57f7b8p+3,
  0x1.3d1ecp+3,
  -0x1.2a76fp-1,
  -0x1.2da37ep+6,
  -0x1.4fc948p-2,
  0x1.002a8ep+0,
  -0x1.20bdd4p+2,
  -0x1.5f6ceep+2,
  0x1.93eb84p-4,
  -0x1.c443cp+2,
  0x1.b34272p+2,
  -0x1.fec732p-1,
  0x1.5a9794p+1,
  0x1.9f7c76p+2,
  0x1.c86a0cp+2,
  0x1.88d064p-1,
  -0x1.782b46p+2,
  -0x1.a8241p-2,
  0x1.01e8cep+2,
  -0x1.65f582p-3,
  -0x1.a6e786p+2,
  0x1.268be2p-2,
  0x1.d4ca68p+2,
  0x1.10d1fep+3,
  0x1.33280ap+1,
  0x1.45129ap+3,
  0x1.b2f9fp+2,
  0x1.c06c2ap+2,
  -0x1.2e4b6p+2,
  0x1.532108p-1,
  -0x1.198f1p+0,
  0x1.32f2ep-1,
  -0x1.63b1fap-3,
  0x1.de7384p-1,
  -0x1.f9c4ep+0,
  0x1.bd8dc4p+2,
  -0x1.748c3p+2,
  -0x1.0c2204p+2,
  0x1.3f400cp+3,
  0x1.16ef8ep+1,
  0x1.ffaf0ap-1,
  -0x1.3df84ep-5,
  -0x1.0a47f6p+3,
  -0x1.074b02p-3,
  0x1.358ba2p+3,
};
