/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package com.android.settings.testutils.shadow;

import android.app.Activity;
import android.app.LoaderManager;

import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowActivity;

/*
 * Shadow for {@link Activity} that has LoadManager accessors.
 */
@Implements(Activity.class)
public class ShadowActivityWithLoadManager extends ShadowActivity {

    private LoaderManager mLoaderManager;

    @Implementation
    public LoaderManager getLoaderManager() {
        return mLoaderManager;
    }

    // Non-Android setter.
    public void setLoaderManager(LoaderManager loaderManager) {
        mLoaderManager = loaderManager;
    }
}
