/*
 * boot.S: assembly language bootstrap
 *
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include "memregions.h"

	.section .flash.boot
	.global _start_flash
_start_flash:
	mov	r0, #0x70		/* 32-bit code + data, MMU mandatory */
	mcr	p15, 0, r0, c1, c0, 0	/* MMU init */

	mov	r0, #0
	mcr	p15, 0, r0, c7, c7, 0	/* flush v3/v4 cache */
	mcr	p15, 0, r0, c8, c7, 0	/* flush v4 TLB */

	mov	r0, #0x80000000		/* I/O base */

	mov	r1, #0xFC		/* ooooooii */
	strb	r1, [r0, #0x40]		/* PADDR config */
	mov	r1, #0x00		/* all in */
	strb	r1, [r0, #0x41]		/* PBDDR config */
	mov	r1, #0x18		/* oooiiooo */
	strb	r1, [r0, #0x43]		/* PDDDR config */
	mov	r1, #0xFF		/* all out */
	strb	r1, [r0, #0xC0]		/* PEDDR config */

	mov	r1, #0x100		/* UART enable bit in SYSCON[1|2] */
	orr	r2, r1, #0x40000	/* EXCKEN enable bit in SYSCON1 */
	str	r2, [r0, #0x100]	/* enable UART1 in SYSCON1 */
	add	r2, r0, #0x1100		/* load address of SYSCON2 in r2 */
	str	r1, [r2]		/* enable UART2 in SYSCON2 */

	mov	r1, #0x00060000		/* UART 8-bit data length */
	orr	r1, r1, #1		/* UART 115200 bps */
	str	r1, [r0, #0x4C0]	/* set UART1 bit rate/line control */
	add	r2, r0, #0x14C0		/* load address of UBRLCR2 in r2 */
	str	r1, [r2]		/* set UART2 bit rate/line control */

	mov	r1, #0x6		/* CLKCTL_73 in SYSCON3 */
	add	r2, r0, #0x2200		/* address of SYSCON3 in r2 */
	str	r1, [r2]		/* set clock speed to 73.728 MHz */

	mov	r1, #0x81		/* 64KHz DRAM refresh period */
	str	r1, [r0, #0x200]	/* set DRFPR */

	mov	r1, #0x500		/* permanent enable, 16bits wide */
	add	r1, r1, #0x42		/* 128Mbit, CAS lat = 2 SDRAM */
	add	r2, r0, #0x2300		/* load address in r2 */
	str	r1, [r2]

	mov	r1, #0x100		/* SDRAM refresh rate */
	add	r2, r0, #0x2340		/* load address in r2 */
	str	r1, [r2]

	ldr	r1, [r0, #0x180]	/* read MEMCFG1 */
	and	r1, r1, #0x0000FF00	/* clear CS0,2,3 */
	orr	r1, r1, #0x94		/* CS0 CLKENB,Wait3,16bit */
	orr	r1, r1, #0x840000	/* CS2 CLKENB,Wait7,16bit */
	orr	r1, r1, #0x9B000000	/* CS3 CLKENB,Wait2,8bit */
	str	r1, [r0, #0x180]	/* update MEMCFG1 */

	ldr	r1, [r0, #0x1C0]	/* read MEMCFG2 */
	and	r1, r1, #0xFFFFFF00	/* clear CS4 */
	orr	r1, r1, #0x98		/* CS4 CLKENB,Wait2,16bit */
	str	r1, [r0, #0x1C0]	/* update MEMCFG2 */

	mov	r0, #0x30000000
	mov	r1, #0x0
	strb	r1, [r0, #0xE]		/* ISA/IDE normal mode */

	mov	sp, #SRAM_START		/* init stack pointer */
	add	sp, sp, #SRAM_SIZE

	bl	entry			/* see entry.c */
1:	b	1b

	.section .ram.boot
	.global _start_ram
_start_ram:
	bl	hmain
2:	b	2b

