/*
 * Copyright (c) 2004 Atmark Techno, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_MEMREGIONS_H
#define _HERMIT_MEMREGIONS_H

#if !defined(__ASSEMBLER__)
#include <target/flash.h>
#include "board.h"
#endif

#define FLASH_START	       0x60000000
#define FLASH_SIZE4MB	       0x00400000
#define FLASH_SIZE8MB          0x00800000
#define FLASH_SIZE             (board_info.flash == FLASH_8MiB ? \
                                FLASH_SIZE8MB : \
                                FLASH_SIZE4MB)

#define FLASH_ALL_START        FLASH_START
#define FLASH_ALL_SIZE         FLASH_SIZE

#define FLASH_BOOTLOADER_START FLASH_START
#define FLASH_BOOTLOADER_SIZE  0x10000

#define FLASH_KERNEL_START     (FLASH_BOOTLOADER_START + FLASH_BOOTLOADER_SIZE)
#define FLASH_KERNEL_SIZE      0x170000

#define FLASH_USERLAND_START   (FLASH_KERNEL_START + FLASH_KERNEL_SIZE)
#define FLASH_USERLAND_SIZE4MB 0x270000
#define FLASH_USERLAND_SIZE8MB 0x670000
#define FLASH_USERLAND_SIZE    (board_info.flash == FLASH_8MiB ? \
                                FLASH_USERLAND_SIZE8MB : \
                                FLASH_USERLAND_SIZE4MB)

#define FLASH_CONFIG_START     (FLASH_USERLAND_START + FLASH_USERLAND_SIZE)
#define FLASH_CONFIG_START8MB  (FLASH_USERLAND_START + FLASH_USERLAND_SIZE8MB)
#define FLASH_CONFIG_SIZE      0x10000

#define FLASH_OPTION_START     (FLASH_BOOTLOADER_START + 0xe000)
#define FLASH_OPTION_SIZE      0x2000

#define FLASH_ALL_NAME          "all"
#define FLASH_BOOTLOADER_NAME   "bootloader"
#define FLASH_KERNEL_NAME       "kernel"
#define FLASH_USERLAND_NAME     "userland"
#define FLASH_CONFIG_NAME       "config"

#define FLASH_ALL_BLOCK4MB      "8x8K/l,62x64K/l,8x8K/l"
#define FLASH_ALL_BLOCK8MB      "8x8K/l,126x64K/l,8x8K/l"
#define FLASH_ALL_BLOCK         (board_info.flash == FLASH_8MiB ? \
                                 FLASH_ALL_BLOCK8MB : \
                                 FLASH_ALL_BLOCK4MB)
#define FLASH_BOOTLOADER_BLOCK  "8x8K/l"
#define FLASH_KERNEL_BLOCK      "23x64K"
#define FLASH_USERLAND_BLOCK4MB "39x64K"
#define FLASH_USERLAND_BLOCK8MB "103x64K"
#define FLASH_USERLAND_BLOCK    (board_info.flash == FLASH_8MiB ? \
                                 FLASH_USERLAND_BLOCK8MB : \
                                 FLASH_USERLAND_BLOCK4MB)
#define FLASH_CONFIG_BLOCK      "8x8K"

#define MTDPARTS210 "mtdparts=armadillo210-nor:0x10000(bootloader)ro,0x170000(kernel),0x270000(userland),-(config)"
#define MTDPARTS2X0 "mtdparts=armadillo2x0-nor:0x10000(bootloader)ro,0x170000(kernel),0x670000(userland),-(config)"

#define SRAM_START		0x80014000
#define SRAM_SIZE		0x00001100

#define BOOTROM_START		0x80090000
#define BOOTROM_SIZE		0x00004000

#define DRAM1_START		0xC0000000
#define DRAM1_SIZE		0x02000000
#define DRAM2_START		0xC4000000
#define DRAM2_SIZE		0x02000000

#define DRAM1_START16		0xC0000000
#define DRAM1_SIZE16		0x00800000
#define DRAM2_START16		0xC1000000
#define DRAM2_SIZE16		0x00800000
#define DRAM3_START16		0xC4800000
#define DRAM3_SIZE16		0x01000000

#define SECTOR_IDX_BOOTLOADER	0
#define SECTOR_IDX_KERNEL	8
#define SECTOR_IDX_USERLAND	31
#define SECTOR_IDX_CONFIG	70 

#define LINUX_PARAM_SIZE	(0x00000f00)
#define LINUX_PARAM_ADDRESS	(DRAM1_START + 0x00000100)

#define LINUX_SRC_SIZE		(FLASH_KERNEL_SIZE)
#define LINUX_SRC_ADDRESS       (FLASH_KERNEL_START)
#define LINUX_LOAD_ADDRESS	(DRAM1_START + 0x00018000)

#define INITRD_SRC_SIZE		(FLASH_USERLAND_SIZE)
#define INITRD_SRC_ADDRESS      (FLASH_USERLAND_START)
#define INITRD_LOAD_ADDRESS	(DRAM3_START16)

#define GUNZIP_MEM_SIZE         0x20000
#define GUNZIP_MEM_BASE         (DRAM1_START + DRAM1_SIZE - \
                                 GUNZIP_MEM_SIZE - 0x10000)

#if !defined(__ASSEMBLER__)
unsigned int get_flash_sector_size(int sector);
#endif

#endif /* _HERMIT_MEMREGIONS_H */
