package cerot.blight.ui;

import java.util.ArrayList;
import java.util.List;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;

/**
 * JavaVMのリストを作成するクラス。
 * @author cero-t
 * 
 */
public class JvmFinder {
	/**
	 * JavaVMのリストを作成します。
	 * @return JavaVMのリスト
	 */
	public List<String> getJvmList() {
		List<VirtualMachineDescriptor> vmList = VirtualMachine.list();
		List<String> result = new ArrayList<String>(vmList.size() + 1);
		result.add("-- Select Java Process --");

		for (VirtualMachineDescriptor vm : vmList) {
			result.add(vm.id() + " : " + vm.displayName());
		}

		return result;
	}
}
