/**
 * $Id: mxElbowEdgeHandler.java,v 1.3 2008/10/25 11:49:36 gaudenz Exp $
 * Copyright (c) 2008, Gaudenz Alder
 */
package com.mxgraph.swing.handler;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraphView;

/**
 * @author Administrator
 * 
 */
public class mxElbowEdgeHandler extends mxEdgeHandler
{

	/**
	 * 
	 */
	protected boolean bendable;

	/**
	 * 
	 * @param graphComponent
	 * @param state
	 */
	public mxElbowEdgeHandler(mxGraphComponent graphComponent, mxCellState state)
	{
		super(graphComponent, state);

		bendable = graphComponent.getGraph().isBendable(state.getCell());
	}

	/**
	 * Hook for subclassers to return tooltip texts for certain points on the
	 * handle.
	 */
	public String getToolTipText(MouseEvent e)
	{
		int index = getIndexAt(e.getX(), e.getY());

		if (index == 1)
		{
			return mxResources.get("doubleClickOrientation");
		}

		return null;
	}

	/**
	 * 
	 */
	protected boolean isFlipEvent(MouseEvent e)
	{
		return e.getClickCount() == 2 && index == 1;
	}

	/**
	 * Hides the middle handle if the edge is not bendable.
	 */
	protected boolean isHandleVisible(int index)
	{
		return super.isHandleVisible(index) && (index != 1 || bendable);
	}

	/**
	 * 
	 */
	protected Rectangle[] createHandles()
	{
		p = createPoints(state);
		Rectangle[] h = new Rectangle[4];

		mxPoint p0 = state.getAbsolutePoint(0);
		mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);

		h[0] = createHandle(p0.getPoint());
		h[2] = createHandle(pe.getPoint());

		// Creates the bend for the middle handle
		mxGeometry geometry = graphComponent.getGraph().getModel().getGeometry(
				state.getCell());
		List points = geometry.getPoints();

		if (points == null || points.isEmpty())
		{
			h[1] = createHandle(new Point((int) (Math.round(p0.getX()) + Math
					.round((pe.getX() - p0.getX()) / 2)), (int) (Math.round(p0
					.getY()) + Math.round((pe.getY() - p0.getY()) / 2))));
		}
		else
		{
			mxGraphView view = graphComponent.getGraph().getView();
			double scale = view.getScale();
			mxPoint trans = view.getTranslate();
			mxPoint pt = (mxPoint) points.get(0);

			h[1] = createHandle(new Point((int) Math.round(scale
					* (pt.getX() + trans.getX() + state.getOrigin().getX())),
					(int) Math.round(scale
							* (pt.getY() + trans.getY() + state.getOrigin()
									.getY()))));
		}

		h[3] = createHandle(state.getAbsoluteOffset().getPoint(),
				mxConstants.HANDLE_SIZE - 2);

		return h;
	}

}
